/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.core;

import java.util.Collections;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.core.event.KeyValueEvent;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.repository.convert.VaultConverter;
import org.springframework.vault.repository.core.VaultKeyValueAdapter;
import org.springframework.vault.repository.mapping.VaultMappingContext;

public class VaultKeyValueTemplate
extends KeyValueTemplate {
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private boolean publishEvents = true;
    private Set<Class<? extends KeyValueEvent>> eventTypesToPublish = Collections.emptySet();

    public VaultKeyValueTemplate(VaultKeyValueAdapter adapter) {
        this(adapter, new VaultMappingContext());
    }

    public VaultKeyValueTemplate(VaultKeyValueAdapter adapter, VaultMappingContext mappingContext) {
        super((KeyValueAdapter)adapter, (MappingContext)mappingContext);
    }

    public void setEventTypesToPublish(Set<Class<? extends KeyValueEvent>> eventTypesToPublish) {
        if (CollectionUtils.isEmpty(eventTypesToPublish)) {
            this.publishEvents = false;
        } else {
            this.publishEvents = true;
            this.eventTypesToPublish = Collections.unmodifiableSet(eventTypesToPublish);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public <T> T insert(Object id, T objectToInsert) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(objectToInsert, (String)"Object to be inserted must not be null!");
        String keyspace = this.resolveKeySpace(objectToInsert.getClass());
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.beforeInsert((Object)id, (String)keyspace, objectToInsert.getClass(), objectToInsert));
        Object saved = this.execute(adapter -> {
            if (adapter.contains(id, keyspace)) {
                throw new DuplicateKeyException("Cannot insert existing object with id %s!. Please use update.".formatted(id));
            }
            return adapter.put(id, objectToInsert, keyspace);
        });
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.afterInsert((Object)id, (String)keyspace, objectToInsert.getClass(), objectToInsert));
        return (T)saved;
    }

    public <T> T update(Object id, T objectToUpdate) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(objectToUpdate, (String)"Object to be updated must not be null!");
        String keyspace = this.resolveKeySpace(objectToUpdate.getClass());
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.beforeUpdate((Object)id, (String)keyspace, objectToUpdate.getClass(), objectToUpdate));
        Object updated = this.execute(adapter -> adapter.put(id, objectToUpdate, keyspace));
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.afterUpdate((Object)id, (String)keyspace, objectToUpdate.getClass(), objectToUpdate, (Object)updated));
        return (T)updated;
    }

    public <T> T delete(T objectToDelete) {
        Class type = ClassUtils.getUserClass(objectToDelete);
        KeyValuePersistentEntity<?, ?> entity = this.getEntity(type);
        Object id = entity.getIdentifierAccessor(objectToDelete).getIdentifier();
        String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.beforeDelete((Object)id, (String)keyspace, (Class)type));
        Object result = this.execute(adapter -> ((VaultKeyValueAdapter)adapter).deleteEntity(objectToDelete, keyspace));
        this.potentiallyPublishEvent((KeyValueEvent)KeyValueEvent.afterDelete((Object)id, (String)keyspace, (Class)type, (Object)result));
        return (T)result;
    }

    public void destroy() throws Exception {
    }

    private String resolveKeySpace(Class<?> type) {
        KeyValuePersistentEntity<?, ?> entity = this.getEntity(type);
        return entity.getKeySpace();
    }

    private KeyValuePersistentEntity<?, ?> getEntity(Class<?> type) {
        return (KeyValuePersistentEntity)this.getMappingContext().getRequiredPersistentEntity(type);
    }

    private void potentiallyPublishEvent(KeyValueEvent event) {
        if (this.eventPublisher == null) {
            return;
        }
        if (this.publishEvents && (this.eventTypesToPublish.isEmpty() || this.eventTypesToPublish.contains(event.getClass()))) {
            this.eventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    public VaultConverter getConverter() {
        return (VaultConverter)this.execute(adapter -> ((VaultKeyValueAdapter)adapter).getConverter());
    }

    public VaultOperations getVaultOperations() {
        return (VaultOperations)this.execute(adapter -> ((VaultKeyValueAdapter)adapter).getVaultOperations());
    }
}

