/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.logging;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.processor.EntryProcessorException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=19001, max=20000)
public interface Log
extends BasicLogger {
    public static Log getLog(Class<?> clazz) {
        return (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)clazz.getName());
    }

    @Message(value="Allocation stack trace:", id=19001)
    public LeakDescription cacheManagerNotClosed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Closing leaked cache manager", id=19002)
    public void leakedCacheManager(@Cause Throwable var1);

    @Message(value="'%s' parameter must not be null", id=19010)
    public NullPointerException parameterMustNotBeNull(String var1);

    @Message(value="Incompatible cache value types specified, expected %s but %s was specified", id=19011)
    public ClassCastException incompatibleType(Class<?> var1, Class<?> var2);

    @Message(value="Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s", id=19015)
    public CacheException cacheAlreadyRegistered(String var1, Configuration var2, Configuration var3);

    @Message(value="Unknown expiry operation: %s", id=19016)
    public IllegalStateException unknownExpiryOperation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error loading %s keys from persistence store", id=19017)
    public void errorLoadingAll(Collection<?> var1, @Cause Throwable var2);

    @Message(value="The configuration class %s is not supported by this implementation", id=19018)
    public IllegalArgumentException configurationClassNotSupported(Class var1);

    @Message(value="Entry processing failed", id=19019)
    public EntryProcessorException entryProcessingFailed(@Cause Throwable var1);

    @Message(value="Cache manager %s has status %s", id=19020)
    public IllegalStateException cacheManagerClosed(URI var1, Object var2);

    @Message(value="Cache %s on %s has status %s", id=19021)
    public IllegalStateException cacheClosed(String var1, URI var2, Object var3);

    @Message(value="Cache named '%s' was not found.", id=19022)
    public CacheException cacheNotFound(String var1);

    @Message(value="Cache is closed.", id=19023)
    public IllegalStateException cacheClosed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Timeout waiting event notification for cache operation.", id=19029)
    public void timeoutWaitingEvent();

    @Message(value="Cache manager is already closed.", id=19030)
    public IllegalStateException cacheManagerClosed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error closing %s", id=19031)
    public void errorClosingCloseable(Closeable var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while getting expiry duration. Fallback to default duration eternal.", id=19032)
    public void getExpiryHasThrown(@Cause Throwable var1);

    public static class LeakDescription
    extends Throwable {
        public LeakDescription() {
        }

        public LeakDescription(String message) {
            super(message);
        }

        @Override
        public String toString() {
            return this.getLocalizedMessage();
        }
    }
}

