/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Implements synchronous acks for messages which have their RSVP flag set)")
public class RSVP
extends Protocol {
    @Property(description="Max time in milliseconds to block for an RSVP'ed message (0 blocks forever).", type=AttributeType.TIME)
    protected long timeout = 10000L;
    @Property(description="Whether an exception should be thrown when the timeout kicks in, and we haven't yet received all acks. An exception would be thrown all the way up to JChannel.send(). If we use RSVP_NB, this will be ignored.")
    protected boolean throw_exception_on_timeout = true;
    @Property(description="When true, we pass the message up to the application and only then send an ack. When false, we send an ack first and only then pass the message up to the application.")
    protected boolean ack_on_delivery = true;
    @Property(description="Interval (in milliseconds) at which we resend the RSVP request. Needs to be < timeout. 0 disables it.", type=AttributeType.TIME)
    protected long resend_interval = 2000L;
    protected short current_id;
    protected TimeScheduler timer;
    protected volatile List<Address> members = new ArrayList<Address>();
    protected final ConcurrentMap<Short, Entry> ids = new ConcurrentHashMap<Short, Entry>();
    protected Future<?> resend_task;
    @ManagedAttribute(description="If we have UNICAST or UNICAST3 in the stack, we don't need to handle unicast messages as they're retransmitted anyway")
    protected boolean handle_unicasts = true;

    @ManagedAttribute(description="Number of pending RSVP requests")
    public int getPendingRsvpRequests() {
        return this.ids.size();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RSVP setTimeout(long t) {
        this.timeout = t;
        return this;
    }

    public boolean throwExceptionOnTimeout() {
        return this.throw_exception_on_timeout;
    }

    public RSVP throwExceptionOnTimeout(boolean b) {
        this.throw_exception_on_timeout = b;
        return this;
    }

    public boolean ackOnDelivery() {
        return this.ack_on_delivery;
    }

    public RSVP ackOnDelivery(boolean b) {
        this.ack_on_delivery = b;
        return this;
    }

    public long getResendInterval() {
        return this.resend_interval;
    }

    public RSVP setResendInterval(long i) {
        this.resend_interval = i;
        return this;
    }

    public boolean handleUnicasts() {
        return this.handle_unicasts;
    }

    public RSVP handleUnicasts(boolean b) {
        this.handle_unicasts = b;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        if (this.timeout > 0L && this.resend_interval > 0L && this.resend_interval >= this.timeout) {
            this.log.warn(Util.getMessage("RSVP_Misconfig"), this.resend_interval, this.timeout);
            this.resend_interval = this.timeout / 3L;
        }
        this.handle_unicasts = this.stack.findProtocol((Class<? extends Protocol>)UNICAST3.class) == null;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.startResendTask();
        Object relay = this.findDownProtocol(RELAY.class);
        if (relay != null) {
            this.log.warn("%s: %s only works within a local cluster, but %s was found: however, RSVPs from other sites will be ignored. Use flag NO_RELAY to make sure RSVP messages are not relayed", this.local_addr, RSVP.class.getSimpleName(), relay.getClass().getSimpleName());
        }
    }

    @Override
    public void stop() {
        this.stopResendTask();
        this.ids.values().forEach(Entry::destroy);
        this.ids.clear();
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        Address target = msg.getDest();
        if (target != null && !this.handle_unicasts || !msg.isFlagSet(Message.Flag.RSVP) && !msg.isFlagSet(Message.Flag.RSVP_NB)) {
            return this.down_prot.down(msg);
        }
        short next_id = this.getNextId();
        RsvpHeader hdr = new RsvpHeader(1, next_id);
        msg.putHeader(this.id, hdr);
        boolean block = msg.isFlagSet(Message.Flag.RSVP);
        Entry entry = target != null ? new Entry(target) : new Entry(this.members);
        Object retval = null;
        try {
            this.ids.put(next_id, entry);
            entry.retainAll(this.members);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(this.local_addr) + ": " + hdr.typeToString() + " --> " + String.valueOf(target == null ? "cluster" : target));
            }
            retval = this.down_prot.down(msg);
            if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                entry.ack(this.local_addr);
            }
            if (block) {
                entry.block(this.timeout);
            }
        }
        catch (TimeoutException e) {
            if (this.throw_exception_on_timeout) {
                throw new RuntimeException(e);
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn(Util.getMessage("RSVP_Timeout"), entry);
            }
        }
        finally {
            Entry tmp;
            if (block && (tmp = (Entry)this.ids.remove(next_id)) != null) {
                tmp.destroy();
            }
        }
        return retval;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!msg.isFlagSet(Message.Flag.RSVP) && !msg.isFlagSet(Message.Flag.RSVP_NB)) {
            return this.up_prot.up(msg);
        }
        Address dest = msg.getDest();
        RsvpHeader hdr = (RsvpHeader)msg.getHeader(this.id);
        if (hdr == null) {
            if (dest == null || this.handle_unicasts) {
                this.log.error(Util.getMessage("MessageWithRSVPFlagNeedsToHaveAnRsvpHeader"));
            }
            return this.up_prot.up(msg);
        }
        Address sender = msg.getSrc();
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.valueOf(this.local_addr) + ": " + hdr.typeToString() + " <-- " + String.valueOf(sender));
        }
        switch (hdr.type) {
            case 1: {
                if (this.ack_on_delivery) {
                    try {
                        Object object = this.up_prot.up(msg);
                        return object;
                    }
                    finally {
                        this.sendResponse(sender, hdr.id);
                    }
                }
                this.sendResponse(sender, hdr.id);
                return this.up_prot.up(msg);
            }
            case 2: {
                return null;
            }
            case 3: {
                this.handleResponse(msg.getSrc(), hdr.id);
                return null;
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<Short> response_ids = null;
        Address dest = batch.dest();
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (!msg.isFlagSet(Message.Flag.RSVP) && !msg.isFlagSet(Message.Flag.RSVP_NB)) continue;
            RsvpHeader hdr = (RsvpHeader)msg.getHeader(this.id);
            if (hdr == null) {
                if (dest != null && !this.handle_unicasts) continue;
                this.log.error(Util.getMessage("MessageWithRSVPFlagNeedsToHaveAnRsvpHeader"));
                continue;
            }
            switch (hdr.type) {
                case 1: {
                    if (!this.ack_on_delivery) {
                        this.sendResponse(batch.sender(), hdr.id);
                        break;
                    }
                    if (response_ids == null) {
                        response_ids = new ArrayList<Short>();
                    }
                    response_ids.add(hdr.id);
                    break;
                }
                case 2: 
                case 3: {
                    if (hdr.type == 3) {
                        this.handleResponse(msg.getSrc(), hdr.id);
                    }
                    it.remove();
                }
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
        if (response_ids != null) {
            Iterator iterator = response_ids.iterator();
            while (iterator.hasNext()) {
                short rsp_id = (Short)iterator.next();
                this.sendResponse(batch.sender(), rsp_id);
            }
        }
    }

    protected void handleView(View view) {
        this.members = view.getMembers();
        Iterator it = this.ids.entrySet().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next().getValue();
            if (entry == null || !entry.retainAll(view.getMembers()) || entry.size() != 0) continue;
            entry.destroy();
            it.remove();
        }
    }

    protected void handleResponse(Address member, short id) {
        Entry entry = (Entry)this.ids.get(id);
        if (entry != null) {
            entry.ack(member);
            if (entry.size() == 0) {
                entry.destroy();
                this.ids.remove(id);
            }
        }
    }

    protected void sendResponse(Address dest, short id) {
        try {
            RsvpHeader hdr = new RsvpHeader(3, id);
            Message msg = new EmptyMessage(dest).putHeader(this.id, hdr).setFlag(Message.Flag.RSVP, Message.Flag.DONT_BUNDLE, Message.Flag.OOB);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(this.local_addr) + ": " + hdr.typeToString() + " --> " + String.valueOf(dest));
            }
            this.down_prot.down(msg);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingResponse"), t);
        }
    }

    protected synchronized short getNextId() {
        short s = this.current_id;
        this.current_id = (short)(s + 1);
        return s;
    }

    protected synchronized void startResendTask() {
        if (this.resend_task == null || this.resend_task.isDone()) {
            this.resend_task = this.timer.scheduleWithFixedDelay(new ResendTask(), this.resend_interval, this.resend_interval, TimeUnit.MILLISECONDS, false);
        }
    }

    protected synchronized void stopResendTask() {
        if (this.resend_task != null) {
            this.resend_task.cancel(false);
        }
        this.resend_task = null;
    }

    @ManagedAttribute(description="Is the resend task running")
    protected synchronized boolean isResendTaskRunning() {
        return this.resend_task != null && !this.resend_task.isDone();
    }

    protected <T extends Protocol> T findDownProtocol(Class<? extends Protocol> cl) {
        for (Protocol tmp = this.down_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            Class<?> protClass = tmp.getClass();
            if (!cl.isAssignableFrom(protClass)) continue;
            return (T)tmp;
        }
        return null;
    }

    protected static class RsvpHeader
    extends Header {
        protected static final byte REQ = 1;
        protected static final byte REQ_ONLY = 2;
        protected static final byte RSP = 3;
        protected byte type;
        protected short id;

        public RsvpHeader() {
        }

        public RsvpHeader(byte type, short id) {
            this.type = type;
            this.id = id;
        }

        @Override
        public short getMagicId() {
            return 76;
        }

        @Override
        public Supplier<? extends Header> create() {
            return RsvpHeader::new;
        }

        @Override
        public int serializedSize() {
            return 3;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeShort(this.id);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.type = in.readByte();
            this.id = in.readShort();
        }

        @Override
        public String toString() {
            return this.typeToString() + "(" + this.id + ")";
        }

        protected String typeToString() {
            switch (this.type) {
                case 1: {
                    return "REQ";
                }
                case 2: {
                    return "REQ-ONLY";
                }
                case 3: {
                    return "RSP";
                }
            }
            return "unknown";
        }
    }

    protected static class Entry {
        protected final AckCollector ack_collector;
        protected final Address target;
        protected final long timestamp;

        protected Entry(Address member) {
            this.target = member;
            this.ack_collector = new AckCollector(member);
            this.timestamp = System.nanoTime();
        }

        protected Entry(Collection<Address> members) {
            this.target = null;
            this.ack_collector = new AckCollector(members);
            this.timestamp = System.nanoTime();
        }

        protected void ack(Address member) {
            this.ack_collector.ack(member);
        }

        protected boolean retainAll(Collection<Address> members) {
            return this.ack_collector.retainAll(members);
        }

        protected int size() {
            return this.ack_collector.size();
        }

        protected void block(long timeout) throws TimeoutException {
            this.ack_collector.waitForAllAcks(timeout);
        }

        protected void destroy() {
            this.ack_collector.destroy();
        }

        public String toString() {
            return this.ack_collector.toString();
        }
    }

    protected class ResendTask
    implements Runnable {
        protected ResendTask() {
        }

        @Override
        public void run() {
            HashSet<Address> sent = new HashSet<Address>();
            boolean mcast_sent = false;
            for (Map.Entry entry : RSVP.this.ids.entrySet()) {
                Short rsvp_id = (Short)entry.getKey();
                Entry val = (Entry)entry.getValue();
                long age = TimeUnit.MILLISECONDS.convert(System.nanoTime() - val.timestamp, TimeUnit.NANOSECONDS);
                if (age >= RSVP.this.timeout || val.ack_collector.size() == 0) {
                    if (age >= RSVP.this.timeout) {
                        RSVP.this.log.warn(Util.getMessage("RSVP_Timeout"), entry);
                    }
                    val.destroy();
                    RSVP.this.ids.remove(rsvp_id);
                    continue;
                }
                Address dest = val.target;
                if (dest == null) {
                    if (mcast_sent) continue;
                    mcast_sent = true;
                } else if (!sent.add(dest)) continue;
                RsvpHeader hdr = new RsvpHeader(2, rsvp_id);
                Message msg = new EmptyMessage(dest).setFlag(Message.Flag.RSVP).putHeader(RSVP.this.id, hdr);
                if (RSVP.this.log.isTraceEnabled()) {
                    RSVP.this.log.trace(String.valueOf(RSVP.this.local_addr) + ": " + hdr.typeToString() + " --> " + String.valueOf(val.target == null ? "cluster" : val.target));
                }
                RSVP.this.down_prot.down(msg);
            }
        }
    }
}

