/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.Leaver;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;

public abstract class GmsImpl {
    protected final GMS gms;
    protected final Merger merger;
    protected final Leaver leaver;
    protected final Log log;

    protected GmsImpl(GMS gms) {
        this.gms = gms;
        this.merger = gms.merger;
        this.leaver = gms.leaver;
        this.log = gms.getLog();
    }

    public abstract void join(Address var1);

    public abstract void joinWithStateTransfer(Address var1);

    public abstract void leave();

    public void handleCoordLeave() {
        this.wrongMethod("handleCoordLeave");
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
    }

    public void handleLeaveResponse(Address sender) {
        this.leaver.handleLeaveResponse(sender);
    }

    public void suspect(Address mbr) {
    }

    public void unsuspect(Address mbr) {
    }

    public void merge(Map<Address, View> views) {
    }

    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
    }

    public void handleMergeResponse(MergeData data, MergeId merge_id) {
    }

    public void handleMergeView(MergeData data, MergeId merge_id) {
    }

    public void handleMergeCancelled(MergeId merge_id) {
    }

    public void handleDigestResponse(Address sender, Digest digest) {
    }

    public void handleMembershipChange(Collection<Request> requests) {
    }

    public void handleViewChange(View new_view, Digest digest) {
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    protected void sendMergeRejectedResponse(Address sender, MergeId merge_id) {
        Message msg = new EmptyMessage(sender).setFlag(Message.Flag.OOB);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getId(), hdr);
        this.log.debug("%s: merge response=%s", this.gms.getAddress(), hdr);
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }

    protected void wrongMethod(String method_name) {
        this.log.warn("%s: %s() should not be invoked on an instance of %s", this.gms.getAddress(), method_name, this.getClass().getName());
    }

    public static class Request {
        public static final int JOIN = 1;
        public static final int LEAVE = 2;
        public static final int COORD_LEAVE = 3;
        public static final int SUSPECT = 4;
        public static final int MERGE = 5;
        public static final int JOIN_WITH_STATE_TRANSFER = 6;
        protected int type = -1;
        protected Address mbr;
        protected Map<Address, View> views;

        public Request(int type) {
            this.type = type;
        }

        public Request(int type, Address mbr) {
            this(type);
            this.mbr = mbr;
        }

        public Request(int type, Address mbr, Map<Address, View> views) {
            this(type, mbr);
            this.views = views;
        }

        public int getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            Request other = (Request)obj;
            if (this.type != other.type) {
                return false;
            }
            return switch (this.type) {
                case 1, 2, 3, 4, 6 -> Objects.equals(this.mbr, other.mbr);
                case 5 -> Objects.equals(this.views, other.views);
                default -> false;
            };
        }

        public int hashCode() {
            return this.type + (this.mbr != null ? this.mbr.hashCode() : 0) + (this.views != null ? this.views.hashCode() : 0);
        }

        public String toString() {
            return switch (this.type) {
                case 1 -> String.format("JOIN(%s)", this.mbr);
                case 6 -> String.format("JOIN_WITH_STATE_TRANSFER(%s)", this.mbr);
                case 2 -> String.format("LEAVE(%s)", this.mbr);
                case 3 -> "COORD_LEAVE";
                case 4 -> String.format("SUSPECT(%s)", this.mbr);
                case 5 -> String.format("MERGE(%d views)", this.views.size());
                default -> String.format("<invalid (type=%d)", this.type);
            };
        }

        public boolean canBeProcessedTogether(Request other) {
            if (other == null) {
                return false;
            }
            int other_type = other.type;
            return !(this.type != 1 && this.type != 2 && this.type != 4 || other_type != 1 && other_type != 2 && other_type != 4);
        }
    }
}

