/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;

public record AsciiString(byte[] val) implements Comparable<AsciiString>
{
    public AsciiString(String str) {
        this(AsciiString.fromString(str));
    }

    public AsciiString(AsciiString str) {
        this(str.val);
    }

    public AsciiString(byte[] val) {
        this.val = val != null ? val : new byte[]{};
    }

    public int length() {
        return this.val.length;
    }

    @Override
    public int compareTo(AsciiString str) {
        if (str == null) {
            return 1;
        }
        if (this.val.hashCode() == str.val.hashCode()) {
            return 0;
        }
        int len1 = this.val.length;
        int len2 = str.val.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = this.val[k];
            byte c2 = str.val[k];
            if (c1 == c2) continue;
            return c1 > c2 ? 1 : -1;
        }
        return Integer.compare(len1, len2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AsciiString)) return false;
        AsciiString as = (AsciiString)obj;
        if (!this.equals(as.val)) return false;
        return true;
    }

    public boolean equals(byte[] other) {
        return Arrays.equals(this.val, other);
    }

    @Override
    public int hashCode() {
        int h = 0;
        if (this.val != null) {
            for (int i = 0; i < this.val.length; ++i) {
                h = 31 * h + this.val[i];
            }
        }
        return h;
    }

    @Override
    public String toString() {
        return new String(this.val);
    }

    private static byte[] fromString(String str) {
        int length = str != null ? str.length() : 0;
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = (byte)str.charAt(i);
        }
        return b;
    }
}

