/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.jgroups.Message;
import org.jgroups.protocols.PerfHeader;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.Average;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

public class BundlerHelper
extends Helper {
    protected static DiagnosticsHandler diag_handler;
    protected static final short PROT = 1567;
    protected static final BundlerProbeHandler ph;
    protected static final Map<String, Average> map;

    protected BundlerHelper(Rule rule) {
        super(rule);
    }

    public static void activated() {
        if (diag_handler == null) {
            try {
                diag_handler = BundlerHelper.createDiagHandler();
                boolean already_present = diag_handler.getProbeHandlers().contains(ph);
                if (!already_present) {
                    diag_handler.registerProbeHandler(ph);
                }
                diag_handler.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void diagCreated(DiagnosticsHandler diag) {
        boolean already_present;
        if (diag_handler != null) {
            diag_handler.stop();
        }
        diag_handler = diag;
        if (diag != null && diag.isEnabled() && !(already_present = diag.getProbeHandlers().contains(ph))) {
            diag.registerProbeHandler(ph);
        }
    }

    public void setStartTime(Message msg) {
        msg.putHeader((short)1567, new PerfHeader(System.nanoTime()));
    }

    public void computeTime(String key, Message msg) {
        PerfHeader hdr = (PerfHeader)msg.getHeader((short)1567);
        if (hdr == null) {
            System.err.printf("PerfHeader not found in message %s\n", msg);
            return;
        }
        long time = System.nanoTime() - hdr.startTime();
        BundlerHelper.addToMap(key, time);
    }

    public void computeTime(String key, List<Message> list) {
        for (Message msg : list) {
            this.computeTime(key, msg);
        }
    }

    public void computeTime(String key, Message[] list) {
        for (Message msg : list) {
            this.computeTime(key, msg);
        }
    }

    protected static void addToMap(String key, long time) {
        Average avg = map.get(key);
        if (avg == null) {
            avg = map.computeIfAbsent(key, __ -> new AverageMinMax(1024).unit(TimeUnit.NANOSECONDS));
        }
        avg.add(time);
    }

    protected static DiagnosticsHandler createDiagHandler() throws Exception {
        DiagnosticsHandler ret = new DiagnosticsHandler();
        Configurator.setDefaultAddressValues(ret, Util.getIpStackType());
        ret.printHeaders(b -> String.format("%s [ip=%s, %s]\n", ret.getLocalAddress(), BundlerHelper.localAddress(), Util.JAVA_VERSION.isEmpty() ? "" : String.format("java %s", Util.JAVA_VERSION)));
        return ret;
    }

    protected static String localAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "n/a";
        }
    }

    static {
        ph = new BundlerProbeHandler();
        map = new ConcurrentHashMap<String, Average>();
    }

    protected static class BundlerProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : keys) {
                if ("bundler-perf".equals(key)) {
                    for (Map.Entry<String, Average> e : map.entrySet()) {
                        m.put(e.getKey(), e.getValue().toString());
                    }
                    continue;
                }
                if (!"bundler-perf-reset".equals(key)) continue;
                map.clear();
            }
            return m;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"bundler-perf", "bundler-perf-reset"};
        }
    }
}

