/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.management.MBeanAttributeInfo;
import org.jgroups.JChannel;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Average;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

public class Metrics {
    protected JChannel ch;
    public static final Predicate<AccessibleObject> IS_NUMBER = obj -> {
        if (obj instanceof Field) {
            Field f = (Field)obj;
            return Metrics.isNumberAndScalar(obj, f.getType());
        }
        if (obj instanceof Method) {
            Method m = (Method)obj;
            return Metrics.isNumberAndScalar(obj, m.getReturnType());
        }
        return false;
    };
    public static final Predicate<AccessibleObject> IS_MANAGED_ATTRIBUTE = obj -> obj.getAnnotation(ManagedAttribute.class) != null;

    public static Map<String, Map<String, Entry<Object>>> extract(JChannel ch) {
        return Metrics.extract(ch, null);
    }

    public static Map<String, Map<String, Entry<Object>>> extract(JChannel ch, Predicate<AccessibleObject> filter) {
        LinkedHashMap<String, Map<String, Entry<Object>>> map = new LinkedHashMap<String, Map<String, Entry<Object>>>();
        for (Protocol p : ch.stack().getProtocols()) {
            map.put(p.getName(), Metrics.extract(p, filter));
        }
        return map;
    }

    public static Map<String, Entry<Object>> extract(Protocol p) {
        return Metrics.extract(p, null);
    }

    public static Map<String, Entry<Object>> extract(Protocol p, Predicate<AccessibleObject> filter) {
        TreeMap<String, Entry<Object>> map = new TreeMap<String, Entry<Object>>();
        ResourceDMBean dm = new ResourceDMBean(p, filter);
        dm.forAllAttributes((k, v) -> {
            MBeanAttributeInfo info = v.info();
            String descr = info != null ? info.getDescription() : "n/a";
            Supplier<Object> getter = () -> {
                try {
                    return v.getter() != null ? v.getter().invoke(null) : null;
                }
                catch (Exception e) {
                    System.err.printf("failed getting value for %s\n", k);
                    return null;
                }
            };
            map.put((String)k, new Entry<Object>(v.type(), descr, getter));
        });
        return map;
    }

    protected void start(boolean numeric) throws Exception {
        this.ch = new JChannel().connect("bla").name("X");
        Map m = Metrics.extract(this.ch, numeric ? IS_NUMBER : null);
        if (numeric) {
            Map map = Metrics.convert(m);
            Metrics.print(map);
        } else {
            Metrics.print(m);
        }
        Util.close((Closeable)this.ch);
    }

    protected static <T> void print(Map<String, Map<String, Entry<T>>> map) {
        for (Map.Entry<String, Map<String, Entry<T>>> e : map.entrySet()) {
            System.out.printf("\n%s:\n---------------\n", e.getKey());
            for (Map.Entry<String, Entry<T>> e2 : e.getValue().entrySet()) {
                Entry<T> entry = e2.getValue();
                Supplier<T> s = entry.supplier();
                if (s == null) continue;
                System.out.printf("  %s: %s\n", e2.getKey(), s.get());
            }
        }
    }

    public static Map<String, Map<String, Entry<Number>>> convert(Map<String, Map<String, Entry<Object>>> m) {
        LinkedHashMap<String, Map<String, Entry<Number>>> retval = new LinkedHashMap<String, Map<String, Entry<Number>>>();
        for (Map.Entry<String, Map<String, Entry<Object>>> entry : m.entrySet()) {
            Map<String, Entry<Object>> m1 = entry.getValue();
            Map<String, Entry<Number>> m2 = Metrics.convertProtocol(m1);
            retval.put(entry.getKey(), m2);
        }
        return retval;
    }

    public static Map<String, Entry<Number>> convertProtocol(Map<String, Entry<Object>> m) {
        TreeMap<String, Entry<Number>> retval = new TreeMap<String, Entry<Number>>();
        for (Map.Entry<String, Entry<Object>> e : m.entrySet()) {
            Entry<Number> tmp;
            Class<?> cl;
            Entry<Object> en = e.getValue();
            AccessibleObject type = en.type();
            Class<?> clazz = cl = type instanceof Field ? ((Field)type).getType() : ((Method)type).getReturnType();
            if (Number.class.isAssignableFrom(cl) || Integer.TYPE.isAssignableFrom(cl) || Long.TYPE.isAssignableFrom(cl) || Float.TYPE.isAssignableFrom(cl) || Double.TYPE.isAssignableFrom(cl)) {
                tmp = new Entry<Number>(en.type(), en.description(), () -> (Number)en.supplier().get());
                retval.put(e.getKey(), tmp);
                continue;
            }
            if (Boolean.TYPE.isAssignableFrom(cl) || Boolean.class.isAssignableFrom(cl)) {
                tmp = new Entry<Number>(en.type(), en.description(), () -> Boolean.TRUE.equals(en.supplier().get()) ? 1 : 0);
                retval.put(e.getKey(), tmp);
                continue;
            }
            if (AverageMinMax.class.isAssignableFrom(cl)) {
                tmp = new Entry<Number>(en.type(), en.description(), () -> Optional.ofNullable((AverageMinMax)en.supplier().get()).map(AverageMinMax::min).orElse(null));
                retval.put(e.getKey() + ".min", tmp);
                tmp = new Entry<Number>(en.type(), en.description(), () -> Optional.ofNullable((AverageMinMax)en.supplier().get()).map(Average::average).orElse(null));
                retval.put(e.getKey(), tmp);
                tmp = new Entry<Number>(en.type(), en.description(), () -> Optional.ofNullable((AverageMinMax)en.supplier().get()).map(AverageMinMax::max).orElse(null));
                retval.put(e.getKey() + ".max", tmp);
                continue;
            }
            if (!Average.class.isAssignableFrom(cl)) continue;
            tmp = new Entry<Number>(en.type(), en.description(), () -> Optional.ofNullable((Average)en.supplier().get()).map(Average::average).orElse(null));
            retval.put(e.getKey(), tmp);
        }
        return retval;
    }

    protected static boolean isNumberAndScalar(AccessibleObject obj, Class<?> cl) {
        if (cl.equals(Float.TYPE) || cl.equals(Float.class) || cl.equals(Double.TYPE) || cl.equals(Double.class) || Average.class.isAssignableFrom(cl)) {
            return true;
        }
        boolean is_number = cl.equals(Integer.TYPE) || cl.equals(Integer.class) || cl.equals(Long.TYPE) || cl.equals(Long.class) || Number.class.isAssignableFrom(cl);
        return is_number && Metrics.isScalar(obj);
    }

    protected static boolean isScalar(AccessibleObject obj) {
        ManagedAttribute annotation = obj.getAnnotation(ManagedAttribute.class);
        if (annotation != null && (annotation.type() == AttributeType.SCALAR || annotation.type() == AttributeType.BYTES)) {
            return true;
        }
        Property prop = obj.getAnnotation(Property.class);
        return prop != null && (prop.type() == AttributeType.SCALAR || prop.type() == AttributeType.BYTES);
    }

    public static void main(String[] args) throws Throwable {
        boolean numeric = args.length > 0 && Boolean.parseBoolean(args[0]);
        new Metrics().start(numeric);
    }

    public record Entry<T>(AccessibleObject type, String description, Supplier<T> supplier) {
        @Override
        public String toString() {
            return String.format("  %s [%s]", this.supplier.get(), this.description);
        }
    }
}

