/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jgroups.util.FileWatcher;
import org.jgroups.util.ReloadingX509KeyManager;
import org.jgroups.util.ReloadingX509TrustManager;
import org.jgroups.util.Util;

public class SslContextFactory {
    private static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private static final String CLASSPATH_RESOURCE = "classpath:";
    private static final ConcurrentHashMap<ClassLoader, Provider[]> PER_CLASSLOADER_PROVIDERS = new ConcurrentHashMap(2);
    private KeyStore keyStore;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private String keyStoreType = "PKCS12";
    private String keyAlias;
    private KeyStore trustStore;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private String trustStoreType = "PKCS12";
    private String sslProtocol = "TLS";
    private ClassLoader classLoader;
    private String providerName;
    private FileWatcher watcher;

    public SslContextFactory keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public SslContextFactory keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslContextFactory keyStorePassword(String keyStorePassword) {
        if (keyStorePassword != null) {
            this.keyStorePassword = keyStorePassword.toCharArray();
        }
        return this;
    }

    public SslContextFactory keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslContextFactory keyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public SslContextFactory keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslContextFactory trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public SslContextFactory trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslContextFactory trustStorePassword(String trustStorePassword) {
        return this.trustStorePassword(trustStorePassword != null ? trustStorePassword.toCharArray() : null);
    }

    public SslContextFactory trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslContextFactory trustStoreType(String trustStoreType) {
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public SslContextFactory sslProtocol(String sslProtocol) {
        if (sslProtocol != null) {
            this.sslProtocol = sslProtocol;
        }
        return this;
    }

    public SslContextFactory provider(String provider) {
        if (provider != null) {
            this.providerName = provider;
        }
        return this;
    }

    public SslContextFactory classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SslContextFactory watcher(FileWatcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public Context build() {
        try {
            SSLContext sslContext;
            KeyManager[] kms = this.getKeyManagers();
            TrustManager[] tms = this.getTrustManagers();
            if (this.providerName != null) {
                Provider provider = SslContextFactory.findProvider(this.providerName, SSLContext.class.getSimpleName(), this.sslProtocol);
                if (provider == null) {
                    throw new IllegalArgumentException("No such provider " + this.providerName);
                }
                sslContext = SSLContext.getInstance(this.sslProtocol, provider);
            } else {
                sslContext = SSLContext.getInstance(this.sslProtocol);
            }
            sslContext.init(kms, tms, null);
            return new Context(sslContext, kms != null ? kms[0] : null, tms != null ? tms[0] : null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SSL", e);
        }
    }

    public void initializeContext(SSLContext sslContext) {
        try {
            KeyManager[] kms = this.getKeyManagers();
            TrustManager[] tms = this.getTrustManagers();
            sslContext.init(kms, tms, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SSL", e);
        }
    }

    private KeyManager[] getKeyManagers() {
        if (this.keyStoreFileName == null && this.keyStore == null) {
            return null;
        }
        if (this.keyStoreFileName == null || this.watcher == null) {
            return new KeyManager[]{this.getKeyManager()};
        }
        return new KeyManager[]{new ReloadingX509KeyManager(this.watcher, Path.of(this.keyStoreFileName, new String[0]), p -> this.getKeyManager())};
    }

    private TrustManager[] getTrustManagers() {
        if (this.trustStoreFileName == null && this.trustStore == null) {
            return null;
        }
        if (this.trustStoreFileName == null || this.watcher == null) {
            return new TrustManager[]{this.getTrustManager()};
        }
        return new TrustManager[]{new ReloadingX509TrustManager(this.watcher, Path.of(this.trustStoreFileName, new String[0]), p -> this.getTrustManager())};
    }

    private X509ExtendedKeyManager getKeyManager() {
        try {
            Provider provider;
            KeyStore ks;
            KeyStore keyStore = ks = this.keyStore != null ? this.keyStore : null;
            if (ks == null) {
                String type = this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE;
                provider = SslContextFactory.findProvider(this.providerName, KeyStore.class.getSimpleName(), type);
                ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
                SslContextFactory.loadKeyStore(ks, this.keyStoreFileName, this.keyStorePassword, this.classLoader);
            } else {
                provider = this.keyStore.getProvider();
            }
            if (this.keyAlias != null) {
                if (ks.containsAlias(this.keyAlias) && ks.isKeyEntry(this.keyAlias)) {
                    KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(this.keyStorePassword);
                    KeyStore.Entry entry = ks.getEntry(this.keyAlias, passParam);
                    ks = provider != null ? KeyStore.getInstance(this.keyStoreType, provider) : KeyStore.getInstance(this.keyStoreType);
                    ks.load(null, null);
                    ks.setEntry(this.keyAlias, entry, passParam);
                } else {
                    throw new RuntimeException(String.format("The alias '%s' does not exist in the key store '%s'", this.keyAlias, this.keyStoreFileName));
                }
            }
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            provider = SslContextFactory.findProvider(this.providerName, KeyManagerFactory.class.getSimpleName(), algorithm);
            KeyManagerFactory kmf = provider != null ? KeyManagerFactory.getInstance(algorithm, provider) : KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.keyStorePassword);
            for (KeyManager km : kmf.getKeyManagers()) {
                if (!(km instanceof X509ExtendedKeyManager)) continue;
                return (X509ExtendedKeyManager)km;
            }
            throw new GeneralSecurityException("Could not obtain an X509ExtendedKeyManager");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Error while initializing SSL context", e);
        }
    }

    private X509ExtendedTrustManager getTrustManager() {
        try {
            Provider provider;
            KeyStore ts;
            KeyStore keyStore = ts = this.trustStore != null ? this.trustStore : null;
            if (ts == null) {
                String type = this.trustStoreType != null ? this.trustStoreType : DEFAULT_KEYSTORE_TYPE;
                provider = SslContextFactory.findProvider(this.providerName, KeyStore.class.getSimpleName(), type);
                ts = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
                SslContextFactory.loadKeyStore(ts, this.trustStoreFileName, this.trustStorePassword, this.classLoader);
            }
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            provider = SslContextFactory.findProvider(this.providerName, TrustManagerFactory.class.getSimpleName(), algorithm);
            TrustManagerFactory tmf = provider != null ? TrustManagerFactory.getInstance(algorithm, provider) : TrustManagerFactory.getInstance(algorithm);
            tmf.init(ts);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                return (X509ExtendedTrustManager)tm;
            }
            throw new GeneralSecurityException("Could not obtain an X509TrustManager");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Error while initializing SSL context", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String keyStoreFileName, char[] keyStorePassword, ClassLoader classLoader) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            if (keyStoreFileName.startsWith(CLASSPATH_RESOURCE)) {
                String fileName = keyStoreFileName.substring(keyStoreFileName.indexOf(":") + 1);
                is = Util.getResourceAsStream(fileName, classLoader);
                if (is == null) {
                    throw new IllegalArgumentException("Cannot find `" + keyStoreFileName + "`");
                }
            } else {
                is = Files.exists(Paths.get(keyStoreFileName, new String[0]), new LinkOption[0]) ? new BufferedInputStream(new FileInputStream(keyStoreFileName)) : Util.getResourceAsStream(keyStoreFileName, classLoader);
            }
            ks.load(is, keyStorePassword);
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close((Closeable)is);
    }

    public static Provider findProvider(String providerName, String serviceType, String algorithm) {
        Provider[] providers;
        for (Provider provider : providers = SslContextFactory.discoverSecurityProviders(Thread.currentThread().getContextClassLoader())) {
            Provider.Service providerService;
            if (providerName != null && !providerName.equals(provider.getName()) || (providerService = provider.getService(serviceType, algorithm)) == null) continue;
            return provider;
        }
        return null;
    }

    public static Provider[] discoverSecurityProviders(ClassLoader classLoader) {
        return PER_CLASSLOADER_PROVIDERS.computeIfAbsent(classLoader, cl -> {
            LinkedHashMap providers = new LinkedHashMap();
            for (Provider provider : Security.getProviders()) {
                providers.put(provider.getClass(), provider);
            }
            Iterator<Provider> loader = ServiceLoader.load(Provider.class, classLoader).iterator();
            while (true) {
                try {
                    while (true) {
                        if (!loader.hasNext()) {
                            return providers.values().toArray(new Provider[0]);
                        }
                        Provider provider = loader.next();
                        providers.putIfAbsent(provider.getClass(), provider);
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        });
    }

    public record Context(SSLContext sslContext, KeyManager keyManager, TrustManager trustManager) {
    }
}

