/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.TagReaderImpl;

public final class EnumMarshallerDelegate<T extends Enum<T>>
extends BaseMarshallerDelegate<T> {
    private final EnumMarshaller<T> enumMarshaller;
    private final Set<Integer> definedValues;

    public EnumMarshallerDelegate(EnumMarshaller<T> enumMarshaller, EnumDescriptor enumDescriptor) {
        this.enumMarshaller = enumMarshaller;
        this.definedValues = new HashSet<Integer>();
        for (EnumValueDescriptor evd : enumDescriptor.getValues()) {
            this.definedValues.add(evd.getNumber());
        }
    }

    @Override
    public EnumMarshaller<T> getMarshaller() {
        return this.enumMarshaller;
    }

    @Override
    public void marshall(ProtobufTagMarshaller.WriteContext ctx, FieldDescriptor fd, T value) throws IOException {
        this.encode(fd.getNumber(), value, ctx.getWriter());
    }

    public void encode(int fieldNumber, T value, TagWriter out) throws IOException {
        int enumValue = this.enumMarshaller.encode(value);
        if (!this.definedValues.contains(enumValue)) {
            throw new IllegalStateException("Undefined enum value " + enumValue + " for " + this.enumMarshaller.getTypeName());
        }
        out.writeEnum(fieldNumber, enumValue);
    }

    @Override
    public T unmarshall(ProtobufTagMarshaller.ReadContext ctx, FieldDescriptor fd) throws IOException {
        int enumValue;
        int expectedTag = fd.getWireTag();
        ProtoStreamReaderImpl reader = ((TagReaderImpl)ctx).getProtoStreamReader();
        UnknownFieldSet unknownFieldSet = reader.getUnknownFieldSet();
        Object value = unknownFieldSet.consumeTag(expectedTag);
        if (value != null) {
            enumValue = ((Long)value).intValue();
        } else {
            TagReader in = ctx.getReader();
            while (true) {
                int tag;
                if ((tag = in.readTag()) == 0) {
                    return null;
                }
                if (tag == expectedTag) {
                    enumValue = in.readEnum();
                    break;
                }
                unknownFieldSet.readSingleField(tag, in);
            }
        }
        return this.decode(expectedTag, enumValue, unknownFieldSet);
    }

    public T decode(int expectedTag, int enumValue, UnknownFieldSet unknownFieldSet) {
        T decoded = this.enumMarshaller.decode(enumValue);
        if (decoded == null && unknownFieldSet != null) {
            unknownFieldSet.putVarintField(expectedTag, enumValue);
        }
        return decoded;
    }
}

