/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import org.infinispan.protostream.impl.json.JsonTokenWriter;

enum JsonToken implements JsonTokenWriter
{
    LEFT_BRACE('{'),
    RIGHT_BRACE('}'),
    STRING('\u0000'),
    COLON(':'),
    VALUE('\u0000'),
    COMMA(','),
    LEFT_BRACKET('['),
    RIGHT_BRACKET(']');

    private final char symbol;

    private JsonToken(char symbol) {
        this.symbol = symbol;
    }

    @Override
    public void append(StringBuilder out) {
        if (this.symbol == '\u0000') {
            throw new IllegalStateException(this.name() + " token should have extra content");
        }
        out.append(this.symbol);
    }

    @Override
    public JsonToken token() {
        return this;
    }

    public boolean isEnd() {
        return this == RIGHT_BRACE || this == RIGHT_BRACKET;
    }

    public boolean isOpen() {
        return this == LEFT_BRACE || this == LEFT_BRACKET;
    }

    public static boolean followedByComma(JsonToken prev) {
        return prev != null && (prev == VALUE || prev.isEnd());
    }

    public static boolean isOpen(JsonToken token) {
        return token != null && token.isOpen();
    }
}

