/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import org.infinispan.protostream.impl.Appendable;
import org.infinispan.protostream.impl.json.JsonToken;

interface JsonTokenWriter
extends Appendable {
    public JsonToken token();

    public static JsonTokenWriter string(String content) {
        return new ContentToken(JsonToken.STRING, content, true);
    }

    public static JsonTokenWriter value(Object content, boolean quoted) {
        return new ContentToken(JsonToken.VALUE, content, quoted);
    }

    public record ContentToken(JsonToken token, Object content, boolean quoted) implements JsonTokenWriter
    {
        @Override
        public void append(StringBuilder out) {
            if (this.quoted) {
                out.append('\"');
            }
            switch (this.token) {
                case STRING: {
                    out.append(this.content);
                    break;
                }
                case VALUE: {
                    if (this.content == null) {
                        out.append("null");
                        break;
                    }
                    out.append(this.content);
                }
            }
            if (this.quoted) {
                out.append('\"');
            }
        }
    }
}

