/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Column {
    private static final Logger logger = LoggerFactory.getLogger(Column.class);
    public static final Nullable NO_NULLS = new Nullable("noNulls");
    public static final Nullable NULLABLE = new Nullable("nullable");
    public static final Nullable NULLABLE_UNKNOWN = new Nullable("nullableUnknown");
    private final String _columnName;
    private final DataType _dataType;
    private final String _sqlTypeName;
    private final Nullable _nullable;
    private final String _defaultValue;
    private final String _remarks;
    private final AutoIncrement _autoIncrement;
    private final Boolean _generatedColumn;

    public Column(String columnName, DataType dataType) {
        this(columnName, dataType, NULLABLE_UNKNOWN);
    }

    public Column(String columnName, DataType dataType, Nullable nullable) {
        this(columnName, dataType, dataType.toString(), nullable, null);
    }

    public Column(String columnName, DataType dataType, String sqlTypeName, Nullable nullable) {
        this(columnName, dataType, sqlTypeName, nullable, null);
    }

    public Column(String columnName, DataType dataType, String sqlTypeName, Nullable nullable, String defaultValue) {
        this(columnName, dataType, sqlTypeName, nullable, defaultValue, null, null);
    }

    public Column(String columnName, DataType dataType, String sqlTypeName, Nullable nullable, String defaultValue, String remarks, AutoIncrement autoIncrement) {
        this(columnName, dataType, sqlTypeName, nullable, defaultValue, remarks, autoIncrement, null);
    }

    public Column(String columnName, DataType dataType, String sqlTypeName, Nullable nullable, String defaultValue, String remarks, AutoIncrement autoIncrement, Boolean generatedColumn) {
        this._columnName = columnName;
        this._dataType = dataType;
        this._sqlTypeName = sqlTypeName;
        this._nullable = nullable;
        this._defaultValue = defaultValue;
        this._remarks = remarks;
        this._autoIncrement = autoIncrement;
        this._generatedColumn = generatedColumn;
    }

    public boolean hasDefaultValue() {
        return this._defaultValue != null;
    }

    public boolean isNotNullable() {
        return this._nullable == NO_NULLS;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public String getSqlTypeName() {
        return this._sqlTypeName;
    }

    public Nullable getNullable() {
        return this._nullable;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String getRemarks() {
        return this._remarks;
    }

    public AutoIncrement getAutoIncrement() {
        return this._autoIncrement;
    }

    public Boolean getGeneratedColumn() {
        return this._generatedColumn;
    }

    public static Nullable nullableValue(int nullable) {
        if (logger.isDebugEnabled()) {
            logger.debug("nullableValue(nullable={}) - start", (Object)String.valueOf(nullable));
        }
        switch (nullable) {
            case 0: {
                return NO_NULLS;
            }
            case 1: {
                return NULLABLE;
            }
            case 2: {
                return NULLABLE_UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unknown constant value " + nullable);
    }

    public static Nullable nullableValue(boolean nullable) {
        if (logger.isDebugEnabled()) {
            logger.debug("nullableValue(nullable={}) - start", (Object)String.valueOf(nullable));
        }
        return nullable ? NULLABLE : NO_NULLS;
    }

    public static Boolean convertMetaDataBoolean(String value) {
        if ("YES".equalsIgnoreCase(value)) {
            return true;
        }
        if ("NO".equalsIgnoreCase(value)) {
            return false;
        }
        return null;
    }

    public String toString() {
        return "(" + this._columnName + ", " + this._dataType + ", " + this._nullable + ")";
    }

    public boolean equals(Object o) {
        logger.debug("equals(o={}) - start", o);
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        if (!this._columnName.equals(column._columnName)) {
            return false;
        }
        if (!this._dataType.equals(column._dataType)) {
            return false;
        }
        if (!this._nullable.equals(column._nullable)) {
            return false;
        }
        if (!this._sqlTypeName.equals(column._sqlTypeName)) {
            return false;
        }
        return !(this._defaultValue == null ? column._defaultValue != null : !this._defaultValue.equals(column._defaultValue));
    }

    public int hashCode() {
        int result = this._columnName.hashCode();
        result = 29 * result + this._dataType.hashCode();
        result = 29 * result + this._sqlTypeName.hashCode();
        result = 29 * result + this._nullable.hashCode();
        result = 29 * result + (this._defaultValue == null ? 0 : this._defaultValue.hashCode());
        return result;
    }

    public static class AutoIncrement {
        public static final AutoIncrement YES = new AutoIncrement("YES");
        public static final AutoIncrement NO = new AutoIncrement("NO");
        public static final AutoIncrement UNKNOWN = new AutoIncrement("UNKNOWN");
        private static final Logger LOGGER = LoggerFactory.getLogger(AutoIncrement.class);
        private final String key;

        private AutoIncrement(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static AutoIncrement autoIncrementValue(String isAutoIncrement) {
            if (LOGGER.isDebugEnabled()) {
                logger.debug("autoIncrementValue(isAutoIncrement={}) - start", (Object)isAutoIncrement);
            }
            AutoIncrement result = UNKNOWN;
            if (isAutoIncrement != null) {
                if (isAutoIncrement.equalsIgnoreCase("YES") || isAutoIncrement.equals("1")) {
                    result = YES;
                } else if (isAutoIncrement.equalsIgnoreCase("NO") || isAutoIncrement.equals("0")) {
                    result = NO;
                }
            }
            return result;
        }

        public String toString() {
            return "autoIncrement=" + this.key;
        }
    }

    public static class Nullable {
        private final String _name;

        private Nullable(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

