/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class TableFormatter {
    public static final String padLeft(String s, int length, char padChar) {
        String result = s;
        char[] padCharArray = TableFormatter.getPadCharArray(s, length, padChar);
        if (padCharArray != null) {
            result = TableFormatter.pad(s, padCharArray, true);
        }
        return result;
    }

    public static final String padRight(String s, int length, char padChar) {
        String result = s;
        char[] padCharArray = TableFormatter.getPadCharArray(s, length, padChar);
        if (padCharArray != null) {
            result = TableFormatter.pad(s, padCharArray, false);
        }
        return result;
    }

    private static final char[] getPadCharArray(String s, int length, char padChar) {
        if (length > 0 && length > s.length()) {
            int padCount = length - s.length();
            char[] padArray = new char[padCount];
            for (int i = 0; i < padArray.length; ++i) {
                padArray[i] = padChar;
            }
            return padArray;
        }
        return null;
    }

    private static final String pad(String s, char[] padArray, boolean padLeft) {
        StringBuilder sb = new StringBuilder(s);
        if (padLeft) {
            sb.insert(0, padArray);
        } else {
            sb.append(padArray);
        }
        return sb.toString();
    }

    public String format(ITable table) throws DataSetException {
        int i;
        StringBuilder sb = new StringBuilder();
        ITableMetaData tableMetaData = table.getTableMetaData();
        sb.append("******");
        sb.append(" table: ").append(tableMetaData.getTableName()).append(" ");
        sb.append("**");
        sb.append(" row count: ").append(table.getRowCount()).append(" ");
        sb.append("******");
        sb.append("\n");
        int width = 20;
        Column[] cols = tableMetaData.getColumns();
        for (i = 0; i < cols.length; ++i) {
            sb.append(TableFormatter.padRight(cols[i].getColumnName(), width, ' '));
            sb.append("|");
        }
        sb.append("\n");
        for (i = 0; i < cols.length; ++i) {
            sb.append(TableFormatter.padRight("", width, '='));
            sb.append("|");
        }
        sb.append("\n");
        for (i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < cols.length; ++j) {
                Object value = table.getValue(i, cols[j].getColumnName());
                String stringValue = String.valueOf(value);
                sb.append(TableFormatter.padRight(stringValue, 20, ' '));
                sb.append("|");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

