/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWriter {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger logger = LoggerFactory.getLogger(XmlWriter.class);
    private Writer out;
    private Charset encoding;
    private Deque<String> stack = new ArrayDeque<String>();
    private StringBuilder attrs;
    private boolean empty;
    private boolean closed = true;
    private boolean pretty = true;
    private boolean wroteText = false;
    private String indent = "  ";
    private String newline = "\n";

    public XmlWriter(Writer writer) {
        this(writer, null);
    }

    public XmlWriter(Writer writer, Charset charset) {
        this.setWriter(writer, charset);
    }

    public XmlWriter(OutputStream outputStream, Charset charset) {
        Charset writerCharset = charset == null ? DEFAULT_CHARSET : charset;
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, writerCharset);
        this.setWriter((Writer)writer, writerCharset);
    }

    public void enablePrettyPrint(boolean enable) {
        if (logger.isDebugEnabled()) {
            logger.debug("enablePrettyPrint(enable={}) - start", (Object)String.valueOf(enable));
        }
        this.pretty = enable;
    }

    public void setIndent(String indent) {
        logger.debug("setIndent(indent={}) - start", (Object)indent);
        this.indent = indent;
    }

    public void setNewline(String newline) {
        logger.debug("setNewline(newline={}) - start", (Object)newline);
        this.newline = newline;
    }

    public XmlWriter writeElementWithText(String name, String text) throws IOException {
        logger.debug("writeElementWithText(name={}, text={}) - start", (Object)name, (Object)text);
        this.writeElement(name);
        this.writeText(text);
        return this.endElement();
    }

    public XmlWriter writeEmptyElement(String name) throws IOException {
        logger.debug("writeEmptyElement(name={}) - start", (Object)name);
        this.writeElement(name);
        return this.endElement();
    }

    public XmlWriter writeElement(String name) throws IOException {
        logger.debug("writeElement(name={}) - start", (Object)name);
        return this.openElement(name);
    }

    private XmlWriter openElement(String name) throws IOException {
        logger.debug("openElement(name={}) - start", (Object)name);
        boolean wasClosed = this.closed;
        this.closeOpeningTag();
        this.closed = false;
        if (this.pretty) {
            if (!wasClosed || this.wroteText) {
                this.out.write(this.newline);
            }
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write("<");
        this.out.write(name);
        this.stack.push(name);
        this.empty = true;
        this.wroteText = false;
        return this;
    }

    private void closeOpeningTag() throws IOException {
        logger.debug("closeOpeningTag() - start");
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.out.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        logger.debug("writeAttributes() - start");
        if (this.attrs != null) {
            this.out.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter writeAttribute(String attr, String value) throws IOException {
        logger.debug("writeAttribute(attr={}, value={}) - start", (Object)attr, (Object)value);
        return this.writeAttribute(attr, value, false);
    }

    public XmlWriter writeAttribute(String attr, String value, boolean literally) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writeAttribute(attr={}, value={}, literally={}) - start", new Object[]{attr, value, String.valueOf(literally)});
        }
        if (this.wroteText) {
            throw new IllegalStateException("The text for the current element has already been written. Cannot add attributes afterwards.");
        }
        if (this.attrs == null) {
            this.attrs = new StringBuilder();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(this.escapeXml(value, literally));
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter endElement() throws IOException {
        logger.debug("endElement() - start");
        if (this.stack.isEmpty()) {
            throw new IOException("Called endElement too many times. ");
        }
        String name = this.stack.pop();
        if (name != null) {
            if (this.empty) {
                this.writeAttributes();
                this.out.write("/>");
            } else {
                if (this.pretty && !this.wroteText) {
                    for (int i = 0; i < this.stack.size(); ++i) {
                        this.out.write(this.indent);
                    }
                }
                this.out.write("</");
                this.out.write(name);
                this.out.write(">");
            }
            if (this.pretty) {
                this.out.write(this.newline);
            }
            this.empty = false;
            this.closed = true;
            this.wroteText = false;
        }
        return this;
    }

    public void close() throws IOException {
        logger.debug("close() - start");
        this.out.flush();
        if (!this.stack.isEmpty()) {
            throw new IOException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter writeText(String text) throws IOException {
        logger.debug("writeText(text={}) - start", (Object)text);
        return this.writeText(text, false);
    }

    public XmlWriter writeText(String text, boolean literally) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writeText(text={}, literally={}) - start", (Object)text, (Object)String.valueOf(literally));
        }
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write(this.escapeXml(text, literally));
        return this;
    }

    public XmlWriter writeCData(String cdata) throws IOException {
        boolean hasAlreadyEnclosingCdata;
        logger.debug("writeCData(cdata={}) - start", (Object)cdata);
        this.closeOpeningTag();
        boolean bl = hasAlreadyEnclosingCdata = cdata.startsWith(CDATA_START) && cdata.endsWith(CDATA_END);
        if (!hasAlreadyEnclosingCdata) {
            cdata = cdata.replaceAll(CDATA_END, "]]]]><![CDATA[>");
        }
        this.empty = false;
        this.wroteText = true;
        if (!hasAlreadyEnclosingCdata) {
            this.out.write(CDATA_START);
        }
        this.out.write(cdata);
        if (!hasAlreadyEnclosingCdata) {
            this.out.write(CDATA_END);
        }
        return this;
    }

    public XmlWriter writeComment(String comment) throws IOException {
        logger.debug("writeComment(comment={}) - start", (Object)comment);
        this.writeChunk("<!-- " + comment + " -->");
        return this;
    }

    private void writeChunk(String data) throws IOException {
        logger.debug("writeChunk(data={}) - start", (Object)data);
        this.closeOpeningTag();
        this.empty = false;
        if (this.pretty && !this.wroteText) {
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write(data);
        if (this.pretty) {
            this.out.write(this.newline);
        }
    }

    public static void main(String[] args) throws IOException {
        logger.debug("main(args={}) - start", (Object[])args);
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws IOException {
        logger.debug("test1() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeElement("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeElement("phone").writeText("4254343").endElement().writeElement("friends").writeElement("bob").endElement().writeElement("jim").endElement().endElement().endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws IOException {
        logger.debug("test2() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeComment("Example of XmlWriter running");
        xmlwriter.writeElement("person");
        xmlwriter.writeAttribute("name", "fred");
        xmlwriter.writeAttribute("age", "12");
        xmlwriter.writeElement("phone");
        xmlwriter.writeText("4254343");
        xmlwriter.endElement();
        xmlwriter.writeComment("Examples of empty tags");
        xmlwriter.writeElement("friends");
        xmlwriter.writeEmptyElement("bob");
        xmlwriter.writeEmptyElement("jim");
        xmlwriter.endElement();
        xmlwriter.writeElementWithText("foo", "This is an example.");
        xmlwriter.endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    private String escapeXml(String str, boolean literally) {
        logger.debug("escapeXml(str={}, literally={}) - start", (Object)str, (Object)Boolean.toString(literally));
        char[] block = null;
        int last = 0;
        StringBuilder buffer = null;
        int strLength = str.length();
        int index = 0;
        for (index = 0; index < strLength; ++index) {
            char currentChar = str.charAt(index);
            String entity = this.convertCharacterToEntity(currentChar, literally);
            if (entity == null) continue;
            if (block == null) {
                block = str.toCharArray();
            }
            if (buffer == null) {
                buffer = new StringBuilder();
            }
            buffer.append(block, last, index - last);
            buffer.append(entity);
            last = index + 1;
        }
        if (last == 0) {
            return str;
        }
        if (last < strLength) {
            if (block == null) {
                block = str.toCharArray();
            }
            if (buffer == null) {
                buffer = new StringBuilder();
            }
            buffer.append(block, last, index - last);
        }
        return buffer.toString();
    }

    protected String convertCharacterToEntity(char currentChar, boolean literally) {
        String entity = null;
        switch (currentChar) {
            case '\t': {
                entity = "&#09;";
                break;
            }
            case '\n': {
                if (!literally) break;
                entity = "&#xA;";
                break;
            }
            case '\r': {
                if (!literally) break;
                entity = "&#xD;";
                break;
            }
            case '&': {
                entity = "&amp;";
                break;
            }
            case '<': {
                entity = "&lt;";
                break;
            }
            case '>': {
                entity = "&gt;";
                break;
            }
            case '\"': {
                entity = "&quot;";
                break;
            }
            case '\'': {
                entity = "&apos;";
                break;
            }
            default: {
                if (currentChar <= '\u007f' || XmlWriter.isValidXmlChar(currentChar)) break;
                entity = "&#" + String.valueOf((int)currentChar) + ";";
            }
        }
        return entity;
    }

    private static boolean isValidXmlChar(int c) {
        switch (c) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return 32 <= c && c <= 55295 || 57344 <= c && c <= 65533 || 65536 <= c && c <= 0x10FFFF;
    }

    private String replace(String value, String original, String replacement) {
        if (logger.isDebugEnabled()) {
            logger.debug("replace(value=" + value + ", original=" + original + ", replacement=" + replacement + ") - start");
        }
        StringBuilder buffer = null;
        int startIndex = 0;
        int lastEndIndex = 0;
        while (true) {
            if ((startIndex = value.indexOf(original, lastEndIndex)) == -1) {
                if (buffer == null) break;
                buffer.append(value.substring(lastEndIndex));
                break;
            }
            if (buffer == null) {
                buffer = new StringBuilder((int)((double)original.length() * 1.5));
            }
            buffer.append(value.substring(lastEndIndex, startIndex));
            buffer.append(replacement);
            lastEndIndex = startIndex + original.length();
        }
        return buffer == null ? value : buffer.toString();
    }

    private void setEncoding(String encoding) {
        logger.debug("setEncoding(encoding={}) - start", (Object)encoding);
        Charset charset = null;
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            charset = Charset.forName(((OutputStreamWriter)this.out).getEncoding());
        }
        if (encoding != null) {
            String ucEncoding = encoding.toUpperCase();
            if ("UTF8".equalsIgnoreCase(ucEncoding)) {
                charset = StandardCharsets.UTF_8;
            } else if ("US-ASCII".equalsIgnoreCase(ucEncoding) || "ASCII".equalsIgnoreCase(ucEncoding)) {
                charset = StandardCharsets.US_ASCII;
            } else if ("ISO-8859-1".equalsIgnoreCase(ucEncoding) || "8859_1".equalsIgnoreCase(ucEncoding) || "ISO8859_1".equalsIgnoreCase(ucEncoding)) {
                charset = StandardCharsets.ISO_8859_1;
            } else if ("UNICODE".equalsIgnoreCase(ucEncoding) || "UNICODE-BIG".equalsIgnoreCase(ucEncoding) || "UNICODE-LITTLE".equalsIgnoreCase(ucEncoding)) {
                charset = StandardCharsets.UTF_16;
            }
        }
        this.setEncoding(charset);
    }

    private void setEncoding(Charset charset) {
        this.encoding = charset;
    }

    public final void setWriter(Writer writer, String encoding) {
        logger.debug("setWriter(writer={}, encoding={}) - start", (Object)writer, (Object)encoding);
        this.setWriter(writer, Charset.forName(encoding));
    }

    public final void setWriter(Writer writer, Charset charset) {
        logger.debug("setWriter(writer={}, charset={}) - start", (Object)writer, (Object)charset);
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(charset);
        }
    }

    public XmlWriter writeDeclaration() throws IOException {
        logger.debug("writeDeclaration() - start");
        if (this.encoding != null) {
            this.out.write("<?xml version='1.0'");
            this.out.write(" encoding='" + this.encoding + "'");
            this.out.write("?>");
            this.out.write(this.newline);
        }
        return this;
    }

    public XmlWriter writeDoctype(String systemId, String publicId) throws IOException {
        logger.debug("writeDoctype(systemId={}, publicId={}) - start", (Object)systemId, (Object)publicId);
        if (systemId != null || publicId != null) {
            this.out.write("<!DOCTYPE dataset");
            if (systemId != null) {
                this.out.write(" SYSTEM \"");
                this.out.write(systemId);
                this.out.write("\"");
            }
            if (publicId != null) {
                this.out.write(" PUBLIC \"");
                this.out.write(publicId);
                this.out.write("\"");
            }
            this.out.write(">");
            this.out.write(this.newline);
        }
        return this;
    }
}

