/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;

@ProtoTypeId(value=1026)
public class CacheAvailabilityUpdateCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final AvailabilityMode availabilityMode;

    @ProtoFactory
    public CacheAvailabilityUpdateCommand(String cacheName, AvailabilityMode availabilityMode) {
        this.cacheName = cacheName;
        this.availabilityMode = availabilityMode;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().forceAvailabilityMode(this.cacheName, this.availabilityMode);
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "UpdateAvailabilityCommand{cacheName='" + this.cacheName + "', availabilityMode=" + String.valueOf((Object)this.availabilityMode) + "}";
    }
}

