/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1127)
public class MetadataTransientMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    Metadata metadata;
    long created;
    long lastUsed;

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long now) {
        this(key, value, metadata, now, now);
    }

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long lastUsed, long created) {
        this(key, value, null, metadata, lastUsed, created);
    }

    protected MetadataTransientMortalCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed, long created) {
        super(key, value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
        this.created = created;
    }

    @ProtoFactory
    MetadataTransientMortalCacheEntry(MarshallableObject<?> wrappedKey, MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, MarshallableObject<Metadata> wrappedMetadata, long created, long lastUsed) {
        super(wrappedKey, wrappedValue, internalMetadata);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.created = created;
        this.lastUsed = lastUsed;
    }

    @ProtoField(number=4, name="metadata")
    public MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=5)
    public long getCreated() {
        return this.created;
    }

    @Override
    @ProtoField(value=6)
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new MetadataTransientMortalCacheValue(this.value, this.internalMetadata, this.metadata, this.created, this.lastUsed);
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
        this.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", created=").append(this.created);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

