/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.file.SingleFileStoreConfiguration;

public class SingleFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, SingleFileStoreConfiguration.attributeDefinitionSet());
    }

    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet) {
        super(builder, attributeSet);
    }

    public SingleFileStoreConfigurationBuilder self() {
        return this;
    }

    public SingleFileStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(SingleFileStoreConfiguration.LOCATION).set((Object)location);
        return this;
    }

    public SingleFileStoreConfigurationBuilder fragmentationFactor(float fragmentationFactor) {
        this.attributes.attribute(SingleFileStoreConfiguration.FRAGMENTATION_FACTOR).set((Object)Float.valueOf(fragmentationFactor));
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        PersistenceUtil.validateGlobalStateStoreLocation(globalConfig, SingleFileStore.class.getSimpleName(), this.attributes.attribute(SingleFileStoreConfiguration.LOCATION));
        super.validate(globalConfig);
    }

    public SingleFileStoreConfiguration create() {
        return new SingleFileStoreConfiguration(this.attributes.protect(), this.async.create());
    }

    @Override
    public Builder<?> read(SingleFileStoreConfiguration template, Combine combine) {
        super.read(template, combine);
        return this;
    }
}

