/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import org.infinispan.commons.util.Experimental;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ResponseCollectors;

@Experimental
public abstract class ValidSingleResponseCollector<S, T>
implements ResponseCollector<S, T> {
    @Override
    public final T addResponse(S sender, Response response) {
        if (response instanceof ValidResponse) {
            ValidResponse rsp = (ValidResponse)response;
            return this.withValidResponse(sender, rsp);
        }
        if (response instanceof ExceptionResponse) {
            ExceptionResponse rsp = (ExceptionResponse)response;
            return this.withException(sender, rsp.getException());
        }
        if (response instanceof CacheNotFoundResponse) {
            return this.targetNotFound(sender);
        }
        return this.withException(sender, (Exception)((Object)new RpcException("Unknown response type: " + String.valueOf(response))));
    }

    @Override
    public final T finish() {
        return null;
    }

    protected T withException(S sender, Exception exception) {
        throw ResponseCollectors.wrapRemoteException(sender, exception);
    }

    protected abstract T withValidResponse(S var1, ValidResponse<?> var2);

    protected abstract T targetNotFound(S var1);
}

