/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.primitive.l;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.util.concurrent.BlockingManager;

@ProtoTypeId(value=1230)
public class PeekLongOperation
implements IntermediateOperation<Long, LongStream, Long, LongStream> {
    private final LongConsumer consumer;
    private BlockingManager blockingManager;

    public PeekLongOperation(LongConsumer consumer) {
        this.consumer = consumer;
    }

    @ProtoFactory
    PeekLongOperation(MarshallableObject<LongConsumer> consumer) {
        this.consumer = MarshallableObject.unwrap(consumer);
    }

    @ProtoField(value=1)
    MarshallableObject<LongConsumer> getConsumer() {
        return MarshallableObject.create(this.consumer);
    }

    @Override
    public LongStream perform(LongStream stream) {
        return stream.peek(this.consumer);
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        this.blockingManager = registry.getBlockingManager().running();
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getCache().running());
        } else {
            registry.wireDependencies(this.consumer);
        }
    }

    @Override
    public Flowable<Long> mapFlowable(Flowable<Long> input) {
        return input.concatMapSingle(t -> Single.fromCompletionStage(this.blockingManager.supplyBlocking(() -> {
            this.consumer.accept((long)t);
            return t;
        }, "publisher-peek")));
    }
}

