/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.xsite.XSiteBackup;

public class IracXSiteBackup
extends XSiteBackup
implements Runnable {
    private final boolean logExceptions;
    private final short index;
    @GuardedBy(value="this")
    private boolean backOffEnabled;
    @GuardedBy(value="this")
    private ExponentialBackOff backOff;
    @GuardedBy(value="this")
    private Runnable afterBackOff = () -> {};

    public IracXSiteBackup(String siteName, boolean sync, long timeout, boolean logExceptions, short index) {
        super(siteName, sync, timeout);
        assert (index >= 0);
        this.logExceptions = logExceptions;
        this.backOff = ExponentialBackOff.NO_OP;
        this.backOffEnabled = false;
        this.index = index;
    }

    public boolean logExceptions() {
        return this.logExceptions;
    }

    public synchronized void enableBackOff() {
        if (this.backOffEnabled) {
            return;
        }
        this.backOffEnabled = true;
        this.backOff.asyncBackOff().thenRun(this);
    }

    synchronized void useBackOff(ExponentialBackOff backOff, Runnable after) {
        this.backOff = backOff;
        this.afterBackOff = after;
    }

    public synchronized boolean isBackOffEnabled() {
        return this.backOffEnabled;
    }

    synchronized void resetBackOff() {
        this.backOffEnabled = false;
        this.backOff.reset();
        this.afterBackOff.run();
    }

    @Override
    public synchronized void run() {
        this.backOffEnabled = false;
        this.afterBackOff.run();
    }

    @Override
    public String toString() {
        return super.toString() + (this.isBackOffEnabled() ? " [backoff-enabled]" : "");
    }

    public int siteIndex() {
        return this.index;
    }
}

