/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.reports.AuditReportUtility;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentReportsUtility;
import com.xebialabs.deployit.core.rest.api.reports.mapper.ReportToCsvMapper;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.report.audit.AuditPermissionRoleRow;
import com.xebialabs.deployit.report.audit.RolePrincipalPermissionRow;
import com.xebialabs.deployit.task.archive.StatusOverviewDataReportLine;
import com.xebialabs.deployit.task.archive.StatusOverviewReportLine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtils {
    private static final Logger log = LoggerFactory.getLogger(ReportUtils.class);
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();

    private ReportUtils() {
    }

    static String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }

    public static Stream<String> toCsv(Set<String> fields, Map<String, String> headersMap, Stream<ReportLine> report) {
        return new ReportToCsvMapper(report, fields, headersMap).getCsv();
    }

    public static List<DateTime> getMonthsOfInterval(DateTime begin, DateTime end) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        DateTime current = begin;
        while (current.isBefore((ReadableInstant)end) || current.isEqual((ReadableInstant)begin)) {
            result.add(current);
            current = current.plusMonths(1);
        }
        if (result.size() == 1 && begin.getMonthOfYear() != end.getMonthOfYear()) {
            result.add(end);
        }
        return result;
    }

    public static String createDownloadToken(DownloadResource downloadResource, Stream<ReportLine> reportLines, String fileName) {
        return ReportUtils.createDownloadToken(downloadResource, null, null, reportLines, fileName);
    }

    public static String createDownloadToken(DownloadResource downloadResource, Set<String> firstRowFields, Map<String, String> headersMap, Stream<ReportLine> reportLines, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), Charset.defaultCharset()));
                 Stream<String> s = ReportUtils.toCsv(firstRowFields, headersMap, reportLines);){
                s.forEachOrdered(line -> {
                    try {
                        writer.write((String)line);
                        writer.write(10);
                    }
                    catch (IOException io) {
                        throw new RuntimeException(io);
                    }
                });
            }
            return downloadResource.register(to, "text/csv");
        }
        catch (Exception re) {
            log.error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }

    public static String createDownloadToken(DownloadResource downloadResource, Report report, String fileName) {
        return ReportUtils.createDownloadToken(downloadResource, report.getLines().stream(), fileName);
    }

    public static String createStepLogs(String fileName, DownloadResource downloadResource, List<String> previousLogs, String currentLog) {
        File to = new File(WorkdirHolder.get().getPath(), fileName);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), Charset.defaultCharset()));){
            if (previousLogs != null && !previousLogs.isEmpty()) {
                for (int i = 0; i < previousLogs.size(); ++i) {
                    writer.write("#");
                    writer.newLine();
                    writer.write("# Attempt nr. " + (i + 1));
                    writer.newLine();
                    writer.write("#");
                    writer.newLine();
                    String[] stringArray = previousLogs.get(i).split("\n");
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String line = stringArray[j];
                        writer.write(line);
                        writer.newLine();
                    }
                }
                writer.write("#");
                writer.newLine();
                writer.write("# Attempt nr. " + (previousLogs.size() + 1));
                writer.newLine();
                writer.write("#");
                writer.newLine();
                if (currentLog != null) {
                    for (String line : currentLog.split("\n")) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
            } else if (currentLog != null) {
                for (String line : currentLog.split("\n")) {
                    writer.write(line);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return downloadResource.register(to, "text/plain");
    }

    public static String createAuditReport(DownloadResource downloadResource, List<RolePrincipalPermissionRow> globalAuditReport, List<AuditPermissionRoleRow> folderAuditReport) {
        DateTimeFormatter auditDateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd_hhmmss");
        String serverName = ServerConfiguration.getInstance().getServerUrl();
        String deployVersion = ReleaseInfo.getReleaseInfo().getVersion();
        return ReportUtils.createReportToken(AuditReportUtility.createAuditReport(globalAuditReport, folderAuditReport, serverName, deployVersion), downloadResource, auditDateFormat);
    }

    public static String createReportToken(Workbook workbook, DownloadResource downloadResource, DateTimeFormatter dateFormat) {
        String fileName = String.format("%s - Deploy.xlsx", dateFormat.print((ReadablePartial)LocalDateTime.now()));
        File to = new File(WorkdirHolder.get().getPath(), fileName);
        try (FileOutputStream fos = new FileOutputStream(to);){
            workbook.write((OutputStream)fos);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return downloadResource.register(to, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml");
    }

    public static String createDeploymentsDashboardReport(DateTime begin, DateTime end, Collection<StatusOverviewReportLine> dashboardReport, Collection<StatusOverviewDataReportLine> deploymentReport, DownloadResource downloadResource) {
        DateTimeFormatter reportDateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd_hhmmss");
        String serverName = ServerConfiguration.getInstance().getServerUrl();
        String deployVersion = ReleaseInfo.getReleaseInfo().getVersion();
        return ReportUtils.createReportToken(DeploymentReportsUtility.createDeploymentsDashboardReport(begin, end, dashboardReport, deploymentReport, serverName, deployVersion), downloadResource, reportDateFormat);
    }
}

