/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;

public final class StandardConversions {
    public static Object convertTextToText(Object source, MediaType sourceType, MediaType destinationType) {
        Charset destinationCharset;
        if (source == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (!sourceType.match(MediaType.TEXT_PLAIN)) {
            throw Log.CONTAINER.invalidMediaType("text/plain", sourceType.toString());
        }
        boolean asString = destinationType.hasStringType();
        Charset sourceCharset = sourceType.getCharset();
        if (sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
            return StandardConversions.convertTextClass(source, destinationType, asString);
        }
        byte[] byteContent = source instanceof byte[] ? (byte[])source : source.toString().getBytes(sourceCharset);
        return StandardConversions.convertTextClass(StandardConversions.convertCharset(byteContent, sourceCharset, destinationCharset), destinationType, asString);
    }

    private static Object convertTextClass(Object text, MediaType destination, boolean asString) {
        if (asString) {
            return text instanceof byte[] ? new String((byte[])text, destination.getCharset()) : text.toString();
        }
        return text instanceof byte[] ? text : (Object)text.toString().getBytes(destination.getCharset());
    }

    public static String convertTextToObject(Object source, MediaType sourceType) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            return source.toString();
        }
        if (source instanceof byte[]) {
            byte[] bytesSource = (byte[])source;
            return new String(bytesSource, sourceType.getCharset());
        }
        throw Log.CONTAINER.invalidTextContent(source);
    }

    public static byte[] convertJavaToProtoStream(Object source, MediaType sourceMediaType, ImmutableSerializationContext ctx) throws IOException, InterruptedException {
        if (source == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("sourceMediaType not conforming to application/x-java-object!");
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof String && StandardConversions.isJavaString(sourceMediaType)) {
            return ((String)source).getBytes(StandardCharsets.UTF_8);
        }
        return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)source);
    }

    private static boolean isJavaString(MediaType mediaType) {
        return mediaType.match(MediaType.APPLICATION_OBJECT) && mediaType.hasStringType();
    }

    public static byte[] convertCharset(Object content, Charset fromCharset, Charset toCharset) {
        if (content == null) {
            return null;
        }
        if (fromCharset == null || toCharset == null) {
            throw new NullPointerException("Charset cannot be null!");
        }
        byte[] bytes = content instanceof String ? content.toString().getBytes(fromCharset) : (content instanceof byte[] ? (byte[])content : content.toString().getBytes(fromCharset));
        if (fromCharset.equals(toCharset)) {
            return bytes;
        }
        CharBuffer inputContent = fromCharset.decode(ByteBuffer.wrap(bytes));
        ByteBuffer result = toCharset.encode(inputContent);
        return Arrays.copyOf(result.array(), result.limit());
    }
}

