/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMember;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class AutoApplicableConverterDescriptorStandardImpl
implements AutoApplicableConverterDescriptor {
    private final ConverterDescriptor linkedConverterDescriptor;

    public AutoApplicableConverterDescriptorStandardImpl(ConverterDescriptor linkedConverterDescriptor) {
        this.linkedConverterDescriptor = linkedConverterDescriptor;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForAttribute(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedType attributeType = ConverterHelper.resolveAttributeType(xProperty, context);
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), attributeType) ? this.linkedConverterDescriptor : null;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForCollectionElement(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedType elementType;
        ResolvedMember<? extends Member> collectionMember = ConverterHelper.resolveMember(xProperty, context);
        Class erasedType = collectionMember.getType().getErasedType();
        if (Map.class.isAssignableFrom(erasedType)) {
            List typeArguments = collectionMember.getType().typeParametersFor(Map.class);
            if (typeArguments.size() < 2) {
                return null;
            }
            elementType = (ResolvedType)typeArguments.get(1);
        } else if (Collection.class.isAssignableFrom(erasedType)) {
            List typeArguments = collectionMember.getType().typeParametersFor(Collection.class);
            if (typeArguments.isEmpty()) {
                return null;
            }
            elementType = (ResolvedType)typeArguments.get(0);
        } else if (erasedType.isArray()) {
            elementType = collectionMember.getType().getArrayElementType();
        } else {
            throw new HibernateException("Attribute was neither a Collection nor a Map : " + String.valueOf(erasedType));
        }
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), elementType) ? this.linkedConverterDescriptor : null;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForMapKey(XProperty xProperty, MetadataBuildingContext context) {
        List typeArguments;
        ResolvedMember<? extends Member> collectionMember = ConverterHelper.resolveMember(xProperty, context);
        if (Map.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            typeArguments = collectionMember.getType().typeParametersFor(Map.class);
            if (typeArguments.isEmpty()) {
                return null;
            }
        } else {
            throw new HibernateException("Attribute was not a Map : " + String.valueOf(collectionMember.getType().getErasedType()));
        }
        ResolvedType keyType = (ResolvedType)typeArguments.get(0);
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), keyType) ? this.linkedConverterDescriptor : null;
    }
}

