/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.internal.util.NullnessUtil;
import org.jboss.logging.Logger;

public class WebSphereJtaPlatform
extends AbstractJtaPlatform {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(WebSphereJtaPlatform.class);
    private final @UnknownKeyFor @NonNull @Initialized Class transactionManagerAccessClass;
    private final @UnknownKeyFor @NonNull @Initialized WebSphereEnvironment webSphereEnvironment;

    public WebSphereJtaPlatform() {
        Class<?> tmAccessClass = null;
        WebSphereEnvironment webSphereEnvironment = null;
        for (WebSphereEnvironment check : WebSphereEnvironment.values()) {
            try {
                tmAccessClass = Class.forName(check.getTmAccessClassName());
                webSphereEnvironment = check;
                log.debugf("WebSphere version : %s", (Object)webSphereEnvironment.getWebSphereVersion());
                break;
            }
            catch (Exception exception) {
            }
        }
        if (webSphereEnvironment == null) {
            throw new JtaPlatformException("Could not locate WebSphere TransactionManager access class");
        }
        this.transactionManagerAccessClass = NullnessUtil.castNonNull(tmAccessClass);
        this.webSphereEnvironment = webSphereEnvironment;
    }

    public WebSphereJtaPlatform(@UnknownKeyFor @NonNull @Initialized Class transactionManagerAccessClass, @UnknownKeyFor @NonNull @Initialized WebSphereEnvironment webSphereEnvironment) {
        this.transactionManagerAccessClass = transactionManagerAccessClass;
        this.webSphereEnvironment = webSphereEnvironment;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        try {
            Method method = this.transactionManagerAccessClass.getMethod("getTransactionManager", new Class[0]);
            return (TransactionManager)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WebSphere TransactionManager", e);
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        String utName = this.webSphereEnvironment.getUtName();
        return (UserTransaction)this.jndiService().locate(utName);
    }

    public static enum WebSphereEnvironment {
        WS_4_0("4.x", "com.ibm.ejs.jts.jta.JTSXA", "jta/usertransaction"),
        WS_5_0("5.0", "com.ibm.ejs.jts.jta.TransactionManagerFactory", "java:comp/UserTransaction"),
        WS_5_1("5.1", "com.ibm.ws.Transaction.TransactionManagerFactory", "java:comp/UserTransaction");

        private final @UnknownKeyFor @NonNull @Initialized String webSphereVersion;
        private final @UnknownKeyFor @NonNull @Initialized String tmAccessClassName;
        private final @UnknownKeyFor @NonNull @Initialized String utName;

        private WebSphereEnvironment(@UnknownKeyFor @NonNull @Initialized String webSphereVersion, String tmAccessClassName, String utName) {
            this.webSphereVersion = webSphereVersion;
            this.tmAccessClassName = tmAccessClassName;
            this.utName = utName;
        }

        public @UnknownKeyFor @NonNull @Initialized String getWebSphereVersion() {
            return this.webSphereVersion;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTmAccessClassName() {
            return this.tmAccessClassName;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUtName() {
            return this.utName;
        }
    }
}

