/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.SessionException;
import org.hibernate.TransientObjectException;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.LazyInitializer;

public abstract class AbstractLazyInitializer
implements LazyInitializer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractLazyInitializer.class);
    private final String entityName;
    private Object id;
    private Object target;
    private boolean initialized;
    private boolean readOnly;
    private boolean unwrap;
    private transient SharedSessionContractImplementor session;
    private Boolean readOnlyBeforeAttachedToSession;
    private String sessionFactoryUuid;
    private String sessionFactoryName;
    private boolean allowLoadOutsideTransaction;

    protected AbstractLazyInitializer(String entityName, Object id, SharedSessionContractImplementor session) {
        this.entityName = entityName;
        this.id = id;
        if (session == null) {
            this.unsetSession();
        } else {
            this.setSession(session);
        }
    }

    @Override
    public final String getEntityName() {
        return this.entityName;
    }

    @Override
    public final Object getInternalIdentifier() {
        return this.id;
    }

    @Override
    public final Object getIdentifier() {
        if (this.isUninitialized() && this.isInitializeProxyWhenAccessingIdentifier()) {
            this.initialize();
        }
        return this.id;
    }

    private MappingMetamodelImplementor getMappingMetamodel() {
        return this.session.getFactory().getRuntimeMetamodels().getMappingMetamodel();
    }

    private EntityPersister getEntityDescriptor() {
        return this.getMappingMetamodel().getEntityDescriptor(this.entityName);
    }

    private SessionFactoryOptions getSessionFactoryOptions() {
        return this.session.getFactory().getSessionFactoryOptions();
    }

    private boolean isInitializeProxyWhenAccessingIdentifier() {
        return this.session != null && this.getSessionFactoryOptions().getJpaCompliance().isJpaProxyComplianceEnabled();
    }

    @Override
    public final void setIdentifier(Object id) {
        this.id = id;
    }

    @Override
    public final boolean isUninitialized() {
        return !this.initialized;
    }

    @Override
    public final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    @Override
    public final void setSession(SharedSessionContractImplementor session) throws HibernateException {
        if (session != this.session) {
            if (session == null) {
                this.unsetSession();
            } else {
                if (this.isConnectedToSession()) {
                    LOG.attemptToAssociateProxyWithTwoOpenSessions(this.entityName, this.id);
                    throw new HibernateException("Illegally attempted to associate proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] with two open sessions");
                }
                this.session = session;
                if (this.readOnlyBeforeAttachedToSession == null) {
                    this.setReadOnly(session.getPersistenceContext().isDefaultReadOnly() || !this.getEntityDescriptor().isMutable());
                } else {
                    this.setReadOnly(this.readOnlyBeforeAttachedToSession);
                    this.readOnlyBeforeAttachedToSession = null;
                }
            }
        }
    }

    private static EntityKey generateEntityKeyOrNull(Object id, SharedSessionContractImplementor session, String entityName) {
        if (id == null || session == null || entityName == null) {
            return null;
        }
        EntityPersister entityDescriptor = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        return session.generateEntityKey(id, entityDescriptor);
    }

    @Override
    public final void unsetSession() {
        this.prepareForPossibleLoadingOutsideTransaction();
        this.session = null;
        this.readOnly = false;
        this.readOnlyBeforeAttachedToSession = null;
    }

    @Override
    public final void initialize() throws HibernateException {
        if (!this.initialized) {
            try {
                if (this.allowLoadOutsideTransaction) {
                    this.permissiveInitialization();
                }
                if (this.session == null) {
                    throw new LazyInitializationException("Could not initialize proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] - no session");
                }
                if (!this.session.isOpenOrWaitingForAutoClose()) {
                    throw new LazyInitializationException("Could not initialize proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] - the owning session was closed");
                }
                if (!this.session.isConnected()) {
                    throw new LazyInitializationException("Could not initialize proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] - the owning session is disconnected");
                }
                this.target = this.session.immediateLoad(this.entityName, this.id);
                this.initialized = true;
                this.checkTargetState(this.session);
            }
            finally {
                if (this.session != null && !this.session.isTransactionInProgress()) {
                    this.session.getJdbcCoordinator().afterTransaction();
                }
            }
        } else {
            this.checkTargetState(this.session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void permissiveInitialization() {
        block15: {
            if (this.session == null) {
                if (this.sessionFactoryUuid == null) {
                    throw new LazyInitializationException("Could not initialize proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] - no session");
                }
                try {
                    SessionFactoryImplementor factory = SessionFactoryRegistry.INSTANCE.getSessionFactory(this.sessionFactoryUuid);
                    SessionImplementor session = factory.openSession();
                    session.getPersistenceContext().setDefaultReadOnly(true);
                    session.setHibernateFlushMode(FlushMode.MANUAL);
                    boolean isJTA = session.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
                    if (!isJTA) {
                        session.beginTransaction();
                    }
                    try {
                        this.target = session.immediateLoad(this.entityName, this.id);
                        this.initialized = true;
                        this.checkTargetState(session);
                        break block15;
                    }
                    finally {
                        try {
                            if (!isJTA) {
                                session.getTransaction().commit();
                            }
                            session.close();
                        }
                        catch (Exception e) {
                            LOG.warn("Unable to close temporary session used to load lazy proxy associated to no session");
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Initialization failure [" + this.entityName + "#" + String.valueOf(this.id) + "]", e);
                    throw new LazyInitializationException(e.getMessage());
                }
            }
            if (this.session.isOpenOrWaitingForAutoClose() && this.session.isConnected()) {
                this.target = this.session.immediateLoad(this.entityName, this.id);
                this.initialized = true;
                this.checkTargetState(this.session);
            } else {
                throw new LazyInitializationException("Could not initialize proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] - session was closed or disconnected");
            }
        }
    }

    public final void initializeWithoutLoadIfPossible() {
        if (!this.initialized && this.session != null && this.session.isOpenOrWaitingForAutoClose()) {
            EntityPersister entityDescriptor = this.getMappingMetamodel().getEntityDescriptor(this.getEntityName());
            EntityKey key = this.session.generateEntityKey(this.getInternalIdentifier(), entityDescriptor);
            Object entity = this.session.getPersistenceContextInternal().getEntity(key);
            if (entity != null) {
                this.setImplementation(entity);
            }
        }
    }

    protected void prepareForPossibleLoadingOutsideTransaction() {
        if (this.session != null) {
            this.allowLoadOutsideTransaction = this.getSessionFactoryOptions().isInitializeLazyStateOutsideTransactionsEnabled();
            if (this.sessionFactoryUuid == null) {
                this.sessionFactoryUuid = this.session.getFactory().getUuid();
            }
            if (this.sessionFactoryName == null) {
                this.sessionFactoryName = this.session.getFactory().getName();
            }
        }
    }

    private void checkTargetState(SharedSessionContractImplementor session) {
        if (!this.unwrap && this.target == null) {
            session.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityName, this.id);
        }
    }

    protected final boolean isConnectedToSession() {
        return this.getProxyOrNull() != null;
    }

    private Object getProxyOrNull() {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getInternalIdentifier(), this.session, this.getEntityName());
        if (entityKey != null && this.session != null && this.session.isOpenOrWaitingForAutoClose()) {
            return this.session.getPersistenceContextInternal().getProxy(entityKey);
        }
        return null;
    }

    @Override
    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    @Override
    public final void setImplementation(Object target) {
        this.target = target;
        this.initialized = true;
    }

    @Override
    public final Object getImplementation(SharedSessionContractImplementor session) throws HibernateException {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getInternalIdentifier(), session, this.getEntityName());
        return entityKey == null ? null : session.getPersistenceContext().getEntity(entityKey);
    }

    @Override
    public String getImplementationEntityName() {
        if (this.session == null) {
            throw new LazyInitializationException("Could not retrieve real entity name [" + this.entityName + "#" + String.valueOf(this.id) + "] - no session");
        }
        if (this.getEntityDescriptor().getEntityMetamodel().hasSubclasses()) {
            this.initialize();
            return this.session.getFactory().bestGuessEntityName(this.target);
        }
        return this.entityName;
    }

    protected final Object getTarget() {
        return this.target;
    }

    @Override
    public final boolean isReadOnlySettingAvailable() {
        return this.session != null && !this.session.isClosed();
    }

    private void errorIfReadOnlySettingNotAvailable() {
        if (this.session == null) {
            throw new TransientObjectException("Proxy for [" + this.entityName + "#" + String.valueOf(this.id) + "] is not associated with a session (the read-only/modifiable setting is only accessible when the proxy is associated with an open session)");
        }
        if (!this.session.isOpenOrWaitingForAutoClose()) {
            throw new SessionException("Proxy for [" + this.entityName + "#" + String.valueOf(this.id) + "] is associated with a closed session (the read-only/modifiable setting is only accessible when the proxy is associated with an open session)");
        }
    }

    @Override
    public final boolean isReadOnly() {
        this.errorIfReadOnlySettingNotAvailable();
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(boolean readOnly) {
        this.errorIfReadOnlySettingNotAvailable();
        if (this.readOnly != readOnly) {
            EntityPersister entityDescriptor = this.getEntityDescriptor();
            if (!entityDescriptor.isMutable() && !readOnly) {
                throw new IllegalStateException("Cannot make proxy [" + this.entityName + "#" + String.valueOf(this.id) + "] for immutable entity modifiable");
            }
            this.readOnly = readOnly;
            if (this.initialized) {
                EntityKey key = AbstractLazyInitializer.generateEntityKeyOrNull(this.getInternalIdentifier(), this.session, this.getEntityName());
                PersistenceContext persistenceContext = this.session.getPersistenceContext();
                if (key != null && persistenceContext.containsEntity(key)) {
                    persistenceContext.setReadOnly(this.target, readOnly);
                }
            }
        }
    }

    public final Boolean isReadOnlyBeforeAttachedToSession() {
        if (this.isReadOnlySettingAvailable()) {
            throw new IllegalStateException("Cannot call isReadOnlyBeforeAttachedToSession when isReadOnlySettingAvailable == true [" + this.entityName + "#" + String.valueOf(this.id) + "]");
        }
        return this.readOnlyBeforeAttachedToSession;
    }

    protected boolean isAllowLoadOutsideTransaction() {
        return this.allowLoadOutsideTransaction;
    }

    protected String getSessionFactoryUuid() {
        return this.sessionFactoryUuid;
    }

    protected String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    final void afterDeserialization(Boolean readOnlyBeforeAttachedToSession, String sessionFactoryUuid, String sessionFactoryName, boolean allowLoadOutsideTransaction) {
        if (this.isReadOnlySettingAvailable()) {
            throw new IllegalStateException("Cannot call afterDeserialization when isReadOnlySettingAvailable == true [" + this.entityName + "#" + String.valueOf(this.id) + "]");
        }
        this.readOnlyBeforeAttachedToSession = readOnlyBeforeAttachedToSession;
        this.sessionFactoryUuid = sessionFactoryUuid;
        this.sessionFactoryName = sessionFactoryName;
        this.allowLoadOutsideTransaction = allowLoadOutsideTransaction;
    }

    @Override
    public boolean isUnwrap() {
        return this.unwrap;
    }

    @Override
    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }
}

