/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;

public class ClassJavaType
extends AbstractClassJavaType<Class> {
    public static final ClassJavaType INSTANCE = new ClassJavaType();

    public ClassJavaType() {
        super(Class.class);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Class value) {
        return value.getName();
    }

    @Override
    public Class fromString(CharSequence string) {
        if (string == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(string.toString());
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Unable to locate named class " + String.valueOf(string));
        }
    }

    @Override
    public <X> X unwrap(Class value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Class.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Class wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof CharSequence) {
            return this.fromString((CharSequence)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

