/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compare
extends AbstractStep {
    private static final Logger logger = LoggerFactory.getLogger(Compare.class);
    private static final String DEFAULT_FORMAT = "flat";
    private String _format;
    private File _src;
    private List _tables = new ArrayList();
    private boolean _sort = false;

    public File getSrc() {
        return this._src;
    }

    public void setSrc(File src) {
        logger.debug("setSrc(src={}) - start", (Object)src);
        this._src = src;
    }

    public void setSort(boolean sort) {
        logger.debug("setSort(sort={}) - start", (Object)String.valueOf(sort));
        this._sort = sort;
    }

    public String getFormat() {
        return this._format != null ? this._format : DEFAULT_FORMAT;
    }

    public void setFormat(String format) {
        logger.debug("setFormat(format={}) - start", (Object)format);
        this.checkDataFormat(format);
        this._format = format;
    }

    public List getTables() {
        return this._tables;
    }

    public void addTable(Table table) {
        logger.debug("addTable(table={}) - start", (Object)table);
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        logger.debug("addQuery(query={}) - start", (Object)query);
        this._tables.add(query);
    }

    @Override
    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        logger.debug("execute(connection={}) - start", (Object)connection);
        IDataSet expectedDataset = this.getSrcDataSet(this._src, this.getFormat(), false);
        IDataSet actualDataset = this.getDatabaseDataSet(connection, this._tables);
        String[] tableNames = null;
        tableNames = this._tables.size() == 0 ? expectedDataset.getTableNames() : actualDataset.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            ITable actualTable;
            ITable expectedTable;
            String tableName = tableNames[i];
            try {
                expectedTable = expectedDataset.getTable(tableName);
            }
            catch (NoSuchTableException e) {
                throw new DatabaseUnitException("Did not find table in source file '" + this._src + "' using format '" + this.getFormat() + "'", e);
            }
            ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
            try {
                actualTable = actualDataset.getTable(tableName);
            }
            catch (NoSuchTableException e) {
                throw new DatabaseUnitException("Did not find table in actual dataset '" + actualDataset + "' via db connection '" + connection + "'", e);
            }
            actualTable = DefaultColumnFilter.includedColumnsTable(actualTable, expectedMetaData.getColumns());
            if (this._sort) {
                expectedTable = new SortedTable(expectedTable);
                actualTable = new SortedTable(actualTable);
            }
            Assertion.assertEquals(expectedTable, actualTable);
        }
    }

    @Override
    public String getLogMessage() {
        return "Executing compare: \n          from file: " + (this._src == null ? null : this._src.getAbsolutePath()) + "\n          with format: " + this._format;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Compare: ");
        result.append(" src=");
        result.append(this._src == null ? "null" : this._src.getAbsolutePath());
        result.append(", format= ");
        result.append(this._format);
        result.append(", tables= ");
        result.append(this._tables);
        return result.toString();
    }
}

