/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value;

import java.util.Map;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.ValueComparerBase;
import org.dbunit.assertion.comparer.value.ValueComparerSelector;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.junit.jupiter.api.Assertions;

public class ConditionalSelectorMultiValueComparer
extends ValueComparerBase {
    private final ValueComparerSelector valueComparerSelector;
    private final Map<Object, ValueComparer> valueComparers;

    public ConditionalSelectorMultiValueComparer(Map<Object, ValueComparer> valueComparers, ValueComparerSelector valueComparerSelector) {
        Assertions.assertNotNull((Object)valueComparerSelector, (String)"valueComparerSelector is null.");
        Assertions.assertNotNull(valueComparers, (String)"valueComparers is null.");
        this.valueComparerSelector = valueComparerSelector;
        this.valueComparers = valueComparers;
    }

    @Override
    public String doCompare(ITable expectedTable, ITable actualTable, int rowNum, String columnName, DataType dataType, Object expectedValue, Object actualValue) throws DatabaseUnitException {
        ValueComparer valueComparer = this.valueComparerSelector.select(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue, this.valueComparers);
        if (valueComparer == null) {
            String msg = "No ValueComparer found by valueComparerSelector=" + this.valueComparerSelector + " in map=" + this.valueComparers;
            throw new IllegalStateException(msg);
        }
        return valueComparer.compare(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append(super.toString());
        sb.append(": [valueComparerSelector=");
        sb.append(this.valueComparerSelector.getClass().getName());
        sb.append(", inValuesValueComparer=");
        sb.append(this.valueComparers);
        sb.append("]");
        return sb.toString();
    }
}

