/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value;

import java.sql.Timestamp;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.comparer.value.ValueComparerTemplateBase;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsActualWithinToleranceOfExpectedTimestampValueComparer
extends ValueComparerTemplateBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final long ONE_SECOND_IN_MILLIS = 1000L;
    public static final long TWO_SECONDS_IN_MILLIS = 2000L;
    public static final long THREE_SECONDS_IN_MILLIS = 3000L;
    public static final long FOUR_SECONDS_IN_MILLIS = 4000L;
    public static final long FIVE_SECONDS_IN_MILLIS = 5000L;
    public static final long ONE_MINUTE_IN_MILLIS = 60000L;
    public static final long TWO_MINUTES_IN_MILLIS = 120000L;
    public static final long THREE_MINUTES_IN_MILLIS = 180000L;
    public static final long FOUR_MINUTES_IN_MILLIS = 240000L;
    public static final long FIVE_MINUTES_IN_MILLIS = 300000L;
    public static final long TEN_MINUTES_IN_MILLIS = 600000L;
    private long lowToleranceValueInMillis;
    private long highToleranceValueInMillis;

    public IsActualWithinToleranceOfExpectedTimestampValueComparer(long lowToleranceValueInMillis, long highToleranceValueInMillis) {
        this.lowToleranceValueInMillis = lowToleranceValueInMillis;
        this.highToleranceValueInMillis = highToleranceValueInMillis;
    }

    @Override
    protected boolean isExpected(ITable expectedTable, ITable actualTable, int rowNum, String columnName, DataType dataType, Object expectedValue, Object actualValue) throws DatabaseUnitException {
        boolean isExpected = expectedValue == null || actualValue == null ? this.isExpectedWithNull(expectedValue, actualValue) : this.isExpectedWithoutNull(expectedValue, actualValue, dataType);
        return isExpected;
    }

    protected boolean isExpectedWithNull(Object expectedValue, Object actualValue) {
        boolean isExpected = expectedValue == actualValue;
        this.log.debug("isExpectedWithNull: {}, actualValue={}, expectedValue={}", new Object[]{isExpected, actualValue, expectedValue});
        return isExpected;
    }

    protected boolean isExpectedWithoutNull(Object expectedValue, Object actualValue, DataType dataType) throws TypeCastException {
        Assertions.assertNotNull((Object)expectedValue, (String)"expectedValue is null.");
        Assertions.assertNotNull((Object)actualValue, (String)"actualValue is null.");
        Object actualTimestamp = this.getCastedValue(actualValue, dataType);
        long actualTime = this.convertValueToTimeInMillis(actualTimestamp);
        Object expectedTimestamp = this.getCastedValue(expectedValue, dataType);
        long expectedTime = this.convertValueToTimeInMillis(expectedTimestamp);
        long diffTime = this.calcTimeDifference(actualTime, expectedTime);
        return this.isTolerant(diffTime);
    }

    protected Object getCastedValue(Object value, DataType type) throws TypeCastException {
        Object castedValue = type == null || type == DataType.UNKNOWN ? value : type.typeCast(value);
        return castedValue;
    }

    protected boolean isTolerant(long diffTime) {
        boolean isLowTolerant = diffTime >= this.lowToleranceValueInMillis;
        boolean isHighTolerant = diffTime <= this.highToleranceValueInMillis;
        boolean isTolerant = isLowTolerant && isHighTolerant;
        this.log.debug("isTolerant: {}, diffTime={}, lowToleranceValueInMillis={}, highToleranceValueInMillis={}", new Object[]{isTolerant, diffTime, this.lowToleranceValueInMillis, this.highToleranceValueInMillis});
        return isTolerant;
    }

    protected long convertValueToTimeInMillis(Object timestampValue) {
        Timestamp timestamp = (Timestamp)timestampValue;
        return timestamp.getTime();
    }

    protected long calcTimeDifference(long actualTimeInMillis, long expectedTimeInMillis) {
        long diffTime = actualTimeInMillis - expectedTimeInMillis;
        long diffTimeAbs = Math.abs(diffTime);
        this.log.debug("calcTimeDifference: actualTimeInMillis={}, expectedTimeInMillis={}, diffInMillisTime={}, diffTimeInMillisAbs={}", new Object[]{actualTimeInMillis, expectedTimeInMillis, diffTime, diffTimeAbs});
        return diffTimeAbs;
    }

    @Override
    protected String getFailPhrase() {
        return "not within tolerance range of " + this.lowToleranceValueInMillis + " - " + this.highToleranceValueInMillis + " milliseconds of";
    }
}

