/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyFilteredTableWrapper
implements ITable {
    private final ITable originalTable;
    private final List filteredRowsMapping;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PrimaryKeyFilteredTableWrapper(ITable table, Set allowedPKs) throws DataSetException {
        if (table == null || allowedPKs == null) {
            throw new IllegalArgumentException("Constructor cannot receive null arguments");
        }
        this.originalTable = table;
        this.filteredRowsMapping = this.setRows(allowedPKs);
    }

    private List setRows(Set allowedPKs) throws DataSetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting rows for table " + this.originalTable.getTableMetaData().getTableName());
        }
        int allowedSize = allowedPKs.size();
        int fullSize = this.originalTable.getRowCount();
        ArrayList<Integer> mapping = new ArrayList<Integer>(allowedSize);
        String pkColumn = this.originalTable.getTableMetaData().getPrimaryKeys()[0].getColumnName();
        for (int row = 0; row < fullSize; ++row) {
            Object pk = this.originalTable.getValue(row, pkColumn);
            if (allowedPKs.contains(pk)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding row " + row + " (pk=" + pk + ")");
                }
                mapping.add(row);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Discarding row " + row + " (pk=" + pk + ")");
        }
        return mapping;
    }

    @Override
    public ITableMetaData getTableMetaData() {
        return this.originalTable.getTableMetaData();
    }

    @Override
    public int getRowCount() {
        return this.filteredRowsMapping.size();
    }

    @Override
    public Object getValue(int row, String column) throws DataSetException {
        int max;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        if (row < (max = this.filteredRowsMapping.size())) {
            int realRow = (Integer)this.filteredRowsMapping.get(row);
            Object value = this.originalTable.getValue(realRow, column);
            return value;
        }
        throw new RowOutOfBoundsException("tried to access row " + row + " but rowCount is " + max);
    }
}

