/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigIntegerDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(BigIntegerDataType.class);

    public BigIntegerDataType() {
        super("BIGINT", -5, BigInteger.class, true);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            long l = ((Number)value).longValue();
            return new BigInteger(String.valueOf(l));
        }
        try {
            BigDecimal bd = new BigDecimal(value.toString());
            return bd.toBigInteger();
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        BigDecimal rawValue = resultSet.getBigDecimal(column);
        BigInteger value = resultSet.wasNull() ? null : rawValue.toBigInteger();
        logger.debug("getSqlValue: column={}, value={}", (Object)column, (Object)value);
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        BigInteger val = (BigInteger)this.typeCast(value);
        BigDecimal valueBigDecimal = val == null ? null : new BigDecimal(val);
        statement.setBigDecimal(column, valueBigDecimal);
    }
}

