/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(DoubleDataType.class);

    DoubleDataType(String name, int sqlType) {
        super(name, sqlType, Double.class, true);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return this.typeCast(new BigDecimal(value.toString()));
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        double rawValue = resultSet.getDouble(column);
        Double value = resultSet.wasNull() ? null : Double.valueOf(rawValue);
        logger.debug("getSqlValue: column={}, value={}", (Object)column, (Object)value);
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setDouble(column, ((Number)this.typeCast(value)).doubleValue());
    }
}

