/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(IntegerDataType.class);

    IntegerDataType(String name, int sqlType) {
        super(name, sqlType, Integer.class, true);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        String stringValue;
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            if ("false".equalsIgnoreCase(string)) {
                return 0;
            }
            if ("true".equalsIgnoreCase(string)) {
                return 1;
            }
        }
        if ((stringValue = value.toString().trim()).length() <= 0) {
            return null;
        }
        try {
            return this.typeCast(new BigDecimal(stringValue));
        }
        catch (NumberFormatException e) {
            throw new TypeCastException(value, this, e);
        }
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        int rawValue = resultSet.getInt(column);
        Integer value = resultSet.wasNull() ? null : Integer.valueOf(rawValue);
        logger.debug("getSqlValue: column={}, value={}", (Object)column, (Object)value);
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setInt(column, (Integer)this.typeCast(value));
    }
}

