/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToleratedDeltaMap {
    private Map _toleratedDeltas;
    private Logger logger = LoggerFactory.getLogger(ToleratedDeltaMap.class);

    public ToleratedDelta findToleratedDelta(String tableName, String columnName) {
        Map toleratedDeltas = this.getToleratedDeltasNullSafe();
        String mapKey = ToleratedDeltaMap.buildMapKey(tableName, columnName);
        ToleratedDelta deltaObj = (ToleratedDelta)toleratedDeltas.get(mapKey);
        return deltaObj;
    }

    private final Map getToleratedDeltasNullSafe() {
        Map res = this.getToleratedDeltas();
        if (res == null) {
            return Collections.emptyMap();
        }
        return res;
    }

    public Map getToleratedDeltas() {
        return this._toleratedDeltas;
    }

    public void addToleratedDelta(ToleratedDelta delta) {
        String key;
        ToleratedDelta removed;
        if (delta == null) {
            throw new NullPointerException("The parameter 'delta' must not be null");
        }
        if (this._toleratedDeltas == null) {
            this._toleratedDeltas = new HashMap();
        }
        if ((removed = this._toleratedDeltas.put(key = ToleratedDeltaMap.buildMapKey(delta), delta)) != null) {
            this.logger.debug("Replaced old tolerated delta object from map with key {}. Old replaced object={}", (Object)key, (Object)removed);
        }
    }

    static String buildMapKey(String tableName, String columnName) {
        return tableName + "." + columnName;
    }

    static String buildMapKey(ToleratedDelta delta) {
        return ToleratedDeltaMap.buildMapKey(delta.getTableName(), delta.getColumnName());
    }

    public static class Precision {
        private static final BigDecimal ZERO = new BigDecimal("0.0");
        private final boolean percentage;
        private final BigDecimal delta;

        public Precision(BigDecimal delta) {
            this(delta, false);
        }

        public Precision(BigDecimal delta, boolean percentage) {
            if (delta.compareTo(ZERO) < 0) {
                throw new IllegalArgumentException("The given delta '" + delta + "' must be >= 0");
            }
            this.delta = delta;
            this.percentage = percentage;
        }

        public boolean isPercentage() {
            return this.percentage;
        }

        public BigDecimal getDelta() {
            return this.delta;
        }
    }

    public static class ToleratedDelta {
        private String tableName;
        private String columnName;
        private Precision toleratedDelta;

        public ToleratedDelta(String tableName, String columnName, double toleratedDelta) {
            this(tableName, columnName, new Precision(new BigDecimal(String.valueOf(toleratedDelta))));
        }

        public ToleratedDelta(String tableName, String columnName, BigDecimal toleratedDelta) {
            this(tableName, columnName, new Precision(toleratedDelta));
        }

        public ToleratedDelta(String tableName, String columnName, BigDecimal toleratedDelta, boolean isPercentage) {
            this(tableName, columnName, new Precision(toleratedDelta, isPercentage));
        }

        public ToleratedDelta(String tableName, String columnName, Precision toleratedDelta) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.toleratedDelta = toleratedDelta;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Precision getToleratedDelta() {
            return this.toleratedDelta;
        }

        public boolean matches(String tableName, String columnName) {
            return this.tableName.equals(tableName) && this.columnName.equals(columnName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("tableName=").append(this.tableName);
            sb.append(", columnName=").append(this.columnName);
            sb.append(", toleratedDelta=").append(this.toleratedDelta);
            return sb.toString();
        }
    }
}

