/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatternMatcher {
    private static final Logger logger = LoggerFactory.getLogger(PatternMatcher.class);
    private final Set _acceptedNames = new HashSet();
    private final Set _acceptedPatterns = new HashSet();

    PatternMatcher() {
    }

    public void addPattern(String patternName) {
        logger.debug("addPattern(patternName={}) - start", (Object)patternName);
        if (patternName.indexOf("*") != -1 || patternName.indexOf("?") != -1) {
            this._acceptedPatterns.add(patternName);
        } else {
            this._acceptedNames.add(patternName.toUpperCase());
        }
    }

    public boolean isEmpty() {
        logger.debug("isEmpty() - start");
        return this._acceptedNames.isEmpty() && this._acceptedPatterns.isEmpty();
    }

    public boolean accept(String name) {
        logger.debug("accept(name={}) - start", (Object)name);
        if (this._acceptedNames.contains(name.toUpperCase())) {
            return true;
        }
        if (this._acceptedPatterns.size() > 0) {
            for (String pattern : this._acceptedPatterns) {
                if (!this.match(pattern, name, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("match(pattern={}, str={}, isCaseSensitive={}) - start", new Object[]{pattern, str, String.valueOf(isCaseSensitive)});
        }
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j]))) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_acceptedNames=").append(this._acceptedNames);
        sb.append(", _acceptedPatterns=").append(this._acceptedPatterns);
        sb.append("]");
        return sb.toString();
    }
}

