/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.sqlloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbunit.dataset.common.handlers.EscapeHandler;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.IsAlnumHandler;
import org.dbunit.dataset.common.handlers.Pipeline;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.dbunit.dataset.common.handlers.QuoteHandler;
import org.dbunit.dataset.common.handlers.SeparatorHandler;
import org.dbunit.dataset.common.handlers.TransparentHandler;
import org.dbunit.dataset.common.handlers.WhitespacesHandler;
import org.dbunit.dataset.sqlloader.SqlLoaderControlParser;
import org.dbunit.dataset.sqlloader.SqlLoaderControlParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLoaderControlParserImpl
implements SqlLoaderControlParser {
    public static final char SEPARATOR_CHAR = ';';
    private Pipeline pipeline;
    private String tableName;
    private boolean hasTrailingNullCols;
    private static final Logger logger = LoggerFactory.getLogger(SqlLoaderControlParserImpl.class);

    public SqlLoaderControlParserImpl() {
        this.resetThePipeline();
    }

    private void resetThePipeline() {
        logger.debug("resetThePipeline() - start");
        this.pipeline = new Pipeline();
        this.pipeline.getPipelineConfig().setSeparatorChar(';');
        this.getPipeline().putFront(SeparatorHandler.ENDPIECE());
        this.getPipeline().putFront(EscapeHandler.ACCEPT());
        this.getPipeline().putFront(IsAlnumHandler.QUOTE());
        this.getPipeline().putFront(QuoteHandler.QUOTE());
        this.getPipeline().putFront(EscapeHandler.ESCAPE());
        this.getPipeline().putFront(WhitespacesHandler.IGNORE());
        this.getPipeline().putFront(TransparentHandler.IGNORE());
    }

    @Override
    public List parse(String csv) throws PipelineException, IllegalInputCharacterException {
        logger.debug("parse(csv={}) - start", (Object)csv);
        this.getPipeline().resetProducts();
        StringCharacterIterator iterator = new StringCharacterIterator(csv);
        char c = iterator.first();
        while (c != '\uffff') {
            this.getPipeline().handle(c);
            c = iterator.next();
        }
        this.getPipeline().noMoreInput();
        this.getPipeline().thePieceIsDone();
        return this.getPipeline().getProducts();
    }

    @Override
    public List parse(URL url) throws IOException, SqlLoaderControlParserException {
        logger.debug("parse(url={}) - start", (Object)url);
        return this.parse(new File(url.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List parse(File controlFile) throws IOException, SqlLoaderControlParserException {
        logger.debug("parse(controlFile={}) - start", (Object)controlFile);
        FileInputStream fis = new FileInputStream(controlFile);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer mbf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        byte[] barray = new byte[(int)fc.size()];
        mbf.get(barray);
        String lines = new String(barray);
        lines = lines.replaceAll("\r", "");
        if (this.parseForRegexp(lines, "(LOAD\\sDATA).*") != null) {
            String fileName = this.parseForRegexp(lines, ".*INFILE\\s'(.*?)'.*");
            File dataFile = this.resolveFile(controlFile.getParentFile(), fileName);
            this.tableName = this.parseForRegexp(lines, ".*INTO\\sTABLE\\s(.*?)\\s.*");
            this.hasTrailingNullCols = this.parseForRegexp(lines, ".*(TRAILING NULLCOLS).*") != "";
            ArrayList rows = new ArrayList();
            List columnList = this.parseColumns(lines, rows);
            try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(new FileInputStream(dataFile)));){
                this.parseTheData(columnList, lineNumberReader, rows);
            }
            return rows;
        }
        throw new SqlLoaderControlParserException("Control file " + controlFile + " not starting using 'LOAD DATA'");
    }

    private File resolveFile(File parentDir, String fileName) {
        File dataFile = new File(fileName);
        if (!dataFile.isAbsolute()) {
            if ((fileName = fileName.replaceAll("\\\\", "/")).startsWith("./")) {
                fileName = fileName.substring(2);
            }
            if (fileName.startsWith(".")) {
                fileName = fileName.substring(1);
            }
            dataFile = new File(parentDir, fileName);
        }
        return dataFile;
    }

    protected String parseForRegexp(String controlFileContent, String regexp) throws IOException {
        logger.debug("parseForRegexp(controlFileContent={}, regexp={}) - start", (Object)controlFileContent, (Object)regexp);
        if (controlFileContent == null) {
            throw new NullPointerException("control file has no content");
        }
        Pattern pattern = Pattern.compile(regexp, 10);
        Matcher matches = pattern.matcher(controlFileContent);
        if (matches.find()) {
            String inFileLine = matches.group(1);
            return inFileLine;
        }
        return null;
    }

    private List parseColumns(String controlFileContent, List rows) throws IOException, SqlLoaderControlParserException {
        ArrayList<String> columnList;
        logger.debug("parseColumns(controlFileContent={}, rows={}) - start", (Object)controlFileContent, (Object)rows);
        Pattern pattern = Pattern.compile(".*FIELDS\\s.*\\(\\n(.*?)\\n\\)", 34);
        Matcher matches = pattern.matcher(controlFileContent);
        if (matches.find()) {
            String columnFragment = matches.group(1);
            columnList = new ArrayList<String>();
            columnFragment = columnFragment.replaceAll("\".*?\"", "");
            columnFragment = columnFragment.replaceAll("\n", "");
            StringTokenizer tok = new StringTokenizer(columnFragment, ",");
            while (tok.hasMoreElements()) {
                String col = (String)tok.nextElement();
                col = this.parseForRegexp(col, ".*^([a-zA-Z0-9_]*)\\s").trim();
                columnList.add(col);
            }
            rows.add(columnList);
        } else {
            columnList = null;
        }
        return columnList;
    }

    private void parseTheData(List columnList, LineNumberReader lineNumberReader, List rows) throws IOException, SqlLoaderControlParserException {
        List columns;
        if (logger.isDebugEnabled()) {
            logger.debug("parseTheData(columnList={}, lineNumberReader={}, rows={}) - start", new Object[]{columnList, lineNumberReader, rows});
        }
        int nColumns = columnList.size();
        while ((columns = this.collectExpectedNumberOfColumns(nColumns, lineNumberReader)) != null) {
            rows.add(columns);
        }
    }

    private List collectExpectedNumberOfColumns(int expectedNumberOfColumns, LineNumberReader lineNumberReader) throws IOException, SqlLoaderControlParserException {
        String anotherLine;
        if (logger.isDebugEnabled()) {
            logger.debug("collectExpectedNumberOfColumns(expectedNumberOfColumns={}, lineNumberReader={}) - start", (Object)String.valueOf(expectedNumberOfColumns), (Object)lineNumberReader);
        }
        if ((anotherLine = lineNumberReader.readLine()) == null) {
            return null;
        }
        List columns = null;
        int columnsCollectedSoFar = 0;
        StringBuilder buffer = new StringBuilder();
        boolean shouldProceed = false;
        while (columnsCollectedSoFar < expectedNumberOfColumns) {
            try {
                buffer.append(anotherLine);
                columns = this.parse(buffer.toString());
                columnsCollectedSoFar = columns.size();
            }
            catch (IllegalStateException e) {
                this.resetThePipeline();
                anotherLine = lineNumberReader.readLine();
                if (anotherLine == null) break;
                buffer.append("\n");
                shouldProceed = true;
            }
            if (shouldProceed) continue;
        }
        if (columnsCollectedSoFar != expectedNumberOfColumns) {
            if (this.hasTrailingNullCols) {
                columns.add("null");
            } else {
                String message = "Expected " + expectedNumberOfColumns + " columns on line " + lineNumberReader.getLineNumber() + ", got " + columnsCollectedSoFar + ". Offending line: " + buffer;
                throw new SqlLoaderControlParserException(message);
            }
        }
        return columns;
    }

    Pipeline getPipeline() {
        return this.pipeline;
    }

    void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }
}

