/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.util.xml.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDataSetWriter
implements IDataSetConsumer {
    private static final Logger logger = LoggerFactory.getLogger(XmlDataSetWriter.class);
    private static final String DATASET = "dataset";
    private static final String TABLE = "table";
    private static final String NAME = "name";
    private static final String COLUMN = "column";
    private static final String ROW = "row";
    private static final String VALUE = "value";
    private static final String NULL = "null";
    private static final String NONE = "none";
    static char[] CDATA_DETECTION_CHARS = new char[]{' ', '\n', '\r', '\t', '&', '<'};
    private XmlWriter _xmlWriter;
    private ITableMetaData _activeMetaData;
    private boolean includeColumnComments = false;

    public XmlDataSetWriter(OutputStream outputStream, Charset charset) {
        this._xmlWriter = new XmlWriter(outputStream, charset);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public XmlDataSetWriter(Writer writer) {
        this._xmlWriter = new XmlWriter(writer);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public XmlDataSetWriter(Writer writer, Charset charset) {
        this._xmlWriter = new XmlWriter(writer, charset);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public void setPrettyPrint(boolean enabled) {
        this._xmlWriter.enablePrettyPrint(enabled);
    }

    public void setIncludeColumnComments(boolean includeColumnComments) {
        this.includeColumnComments = includeColumnComments;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        logger.trace("write(dataSet{}) - start", (Object)dataSet);
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer(this);
        provider.produce();
    }

    boolean needsCData(String text) {
        logger.trace("needsCData(text={}) - start", (Object)text);
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            for (int j = 0; j < CDATA_DETECTION_CHARS.length; ++j) {
                if (CDATA_DETECTION_CHARS[j] != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void startDataSet() throws DataSetException {
        logger.trace("startDataSet() - start");
        try {
            this._xmlWriter.writeDeclaration();
            this._xmlWriter.writeElement(DATASET);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public void endDataSet() throws DataSetException {
        logger.trace("endDataSet() - start");
        try {
            this._xmlWriter.endElement();
            this._xmlWriter.close();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public void startTable(ITableMetaData metaData) throws DataSetException {
        logger.trace("startTable(metaData={}) - start", (Object)metaData);
        try {
            this._activeMetaData = metaData;
            String tableName = this._activeMetaData.getTableName();
            this._xmlWriter.writeElement(TABLE);
            this._xmlWriter.writeAttribute(NAME, tableName);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                this._xmlWriter.writeElementWithText(COLUMN, columnName);
            }
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public void endTable() throws DataSetException {
        logger.trace("endTable() - start");
        try {
            this._xmlWriter.endElement();
            this._activeMetaData = null;
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public void row(Object[] values) throws DataSetException {
        logger.trace("row(values={}) - start", values);
        try {
            this._xmlWriter.writeElement(ROW);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                Object value = values[i];
                if (value == null) {
                    this._xmlWriter.writeEmptyElement(NULL);
                } else if (value == ITable.NO_VALUE) {
                    this._xmlWriter.writeEmptyElement(NONE);
                } else {
                    try {
                        String stringValue = DataType.asString(value);
                        this._xmlWriter.writeElement(VALUE);
                        if (this.needsCData(stringValue)) {
                            this.writeValueCData(stringValue);
                        } else if (stringValue.length() > 0) {
                            this.writeValue(stringValue);
                        }
                        this._xmlWriter.endElement();
                    }
                    catch (TypeCastException e) {
                        throw new DataSetException("table=" + this._activeMetaData.getTableName() + ", row=" + i + ", column=" + columnName + ", value=" + value, e);
                    }
                }
                if (!this.includeColumnComments) continue;
                this._xmlWriter.writeComment(columnName);
            }
            this._xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    protected void writeValueCData(String stringValue) throws IOException {
        logger.trace("writeValueCData(stringValue={}) - start", (Object)stringValue);
        this._xmlWriter.writeCData(stringValue);
    }

    protected void writeValue(String stringValue) throws IOException {
        logger.trace("writeValue(stringValue={}) - start", (Object)stringValue);
        this._xmlWriter.writeText(stringValue);
    }

    protected final XmlWriter getXmlWriter() {
        return this._xmlWriter;
    }
}

