/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.util.List;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.impl.json.BaseJsonWriter;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;
import org.infinispan.protostream.impl.json.RootJsonWriter;

final class ContainerObjectWriter
extends BaseJsonWriter {
    private int containerFields = 1;

    ContainerObjectWriter(ImmutableSerializationContext ctx, List<JsonTokenWriter> ast, FieldDescriptor descriptor) {
        super(ctx, ast, descriptor);
    }

    @Override
    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
    }

    @Override
    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        ++this.containerFields;
        if (this.containerFields < 4) {
            super.onTag(fieldNumber, fieldDescriptor, tagValue);
            return;
        }
        if (this.containerFields == 4) {
            if (JsonToken.followedByComma(this.lastToken())) {
                this.pushToken(JsonToken.COMMA);
            }
            this.pushToken(JsonTokenWriter.string("_value"));
            this.pushToken(JsonToken.COLON);
            this.pushToken(JsonToken.LEFT_BRACKET);
        }
        if (JsonToken.followedByComma(this.lastToken())) {
            this.pushToken(JsonToken.COMMA);
        }
        switch (fieldNumber) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                this.writePrimitiveContainer(fieldDescriptor, tagValue);
                break;
            }
            default: {
                GenericDescriptor descriptor = this.ctx.getDescriptorByTypeId(0);
                RootJsonWriter delegate = new RootJsonWriter(this.ctx, this.ast);
                delegate.onStart(descriptor);
                delegate.onTag(fieldNumber, fieldDescriptor, tagValue);
                delegate.onEnd();
            }
        }
    }

    @Override
    protected boolean isRoot() {
        return false;
    }

    private void writePrimitiveContainer(FieldDescriptor fieldDescriptor, Object tagValue) {
        this.pushToken(JsonToken.LEFT_BRACE);
        this.pushToken(JsonTokenWriter.string(fieldDescriptor.getTypeName()));
        this.pushToken(JsonToken.COLON);
        this.writeTagValue(fieldDescriptor, tagValue);
        this.pushToken(JsonToken.RIGHT_BRACE);
    }

    @Override
    public void onEnd() {
        this.pushToken(JsonToken.RIGHT_BRACKET);
    }
}

