/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.RequestUUID;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=25)
public final class CommandInvocationId {
    public static final CommandInvocationId DUMMY_INVOCATION_ID = new CommandInvocationId(RequestUUID.NO_REQUEST);
    private static final AtomicLong nextId = new AtomicLong(0L);
    private final RequestUUID requestUUID;

    CommandInvocationId(RequestUUID requestUUID) {
        this.requestUUID = Objects.requireNonNull(requestUUID);
    }

    @ProtoFactory
    static CommandInvocationId protoFactory(RequestUUID requestUUID) {
        return Objects.equals(requestUUID, RequestUUID.NO_REQUEST) ? DUMMY_INVOCATION_ID : new CommandInvocationId(requestUUID);
    }

    public long getId() {
        return this.requestUUID.getRequestId();
    }

    public Address getAddress() {
        return this.requestUUID.toAddress();
    }

    @ProtoField(value=1)
    public RequestUUID getRequestUUID() {
        return this.requestUUID;
    }

    public static CommandInvocationId generateId(Address address) {
        return new CommandInvocationId(RequestUUID.of(address, nextId.getAndIncrement()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandInvocationId that = (CommandInvocationId)o;
        return this.requestUUID.equals(that.requestUUID);
    }

    public int hashCode() {
        return this.requestUUID.hashCode();
    }

    public String toString() {
        return "CommandInvocation:" + this.requestUUID.toIdString();
    }

    public static String show(CommandInvocationId id) {
        return id == DUMMY_INVOCATION_ID ? "" : id.toString();
    }
}

