/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.ComponentRegistryTracker;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.Scopes;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BasicComponentRegistryImpl
implements BasicComponentRegistry {
    private static final Log log = LogFactory.getLog(BasicComponentRegistryImpl.class);
    private final ModuleRepository moduleRepository;
    private final Scopes scope;
    private final BasicComponentRegistry next;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ConcurrentMap<String, ComponentWrapper> components = new ConcurrentHashMap<String, ComponentWrapper>();
    @GuardedBy(value="lock")
    private final List<String> startedComponents = new ArrayList<String>();
    private final ConcurrentMap<Thread, ComponentPath> mutatorThreads;
    private final ComponentRegistryTracker tracker;
    private volatile ComponentStatus status;
    private final WireContext lookup = new WireContext(this);

    public BasicComponentRegistryImpl(ModuleRepository moduleRepository, boolean isGlobal, BasicComponentRegistry next) {
        this.moduleRepository = moduleRepository;
        this.scope = isGlobal ? Scopes.GLOBAL : Scopes.NAMED_CACHE;
        this.next = next;
        this.status = ComponentStatus.RUNNING;
        this.mutatorThreads = new ConcurrentHashMap<Thread, ComponentPath>();
        this.tracker = log.isTraceEnabled() ? ComponentRegistryTracker.timeTracking(this, isGlobal) : ComponentRegistryTracker.disabled();
        this.registerComponent(BasicComponentRegistry.class, this, false);
    }

    @Override
    public <T, U extends T> ComponentRef<T> getComponent(String name, Class<U> componentType) {
        return this.getComponent0(name, componentType, true);
    }

    @Override
    public <T> ComponentRef<T> lazyGetComponent(Class<T> componentType) {
        return this.getComponent0(componentType.getName(), componentType, false);
    }

    @Override
    public void blameInitialization() {
        if (this.tracker != null && log.isTraceEnabled()) {
            String name = this.scope == Scopes.NAMED_CACHE ? (String)this.getComponent("cacheName", String.class).running() : this.scope.name();
            log.tracef("Component initialization metrics %s:%n%s", name, this.tracker.dump());
            this.tracker.clear();
        }
    }

    @Override
    public MBeanMetadata getMBeanMetadata(String className) {
        HashMap<String, MBeanMetadata.OperationMetadata> operations;
        HashMap<String, MBeanMetadata.AttributeMetadata> attributes;
        MBeanMetadata metadata;
        block4: {
            metadata = this.moduleRepository.getMBeanMetadata(className);
            if (metadata == null) {
                return null;
            }
            attributes = new HashMap<String, MBeanMetadata.AttributeMetadata>();
            operations = new HashMap<String, MBeanMetadata.OperationMetadata>();
            MBeanMetadata currentMetadata = metadata;
            do {
                for (MBeanMetadata.AttributeMetadata attribute : currentMetadata.getAttributes()) {
                    MBeanMetadata.AttributeMetadata existingAttr = attributes.put(attribute.getName(), attribute);
                    if (existingAttr == null) continue;
                    throw new IllegalStateException("Overriding/duplicate JMX attributes are not allowed. Attribute " + attribute.getName() + " already exists in a subclass of " + className);
                }
                for (MBeanMetadata.OperationMetadata operation : currentMetadata.getOperations()) {
                    MBeanMetadata.OperationMetadata existingOp = operations.put(operation.getSignature(), operation);
                    if (existingOp == null) continue;
                    throw new IllegalStateException("Overriding/duplicate JMX operations are not allowed. Operation " + operation.getSignature() + " already exists in a subclass of " + className);
                }
                className = currentMetadata.getSuperMBeanClassName();
                if (className == null) break block4;
            } while ((currentMetadata = this.moduleRepository.getMBeanMetadata(className)) != null);
            throw new IllegalStateException("Missing MBean metadata for class " + className);
        }
        return new MBeanMetadata(metadata.getJmxObjectName(), metadata.getDescription(), null, metadata.scope(), attributes.values(), operations.values());
    }

    <T, U extends T> ComponentRef<T> getComponent0(String name, Class<U> componentType, boolean needInstance) {
        ComponentRef nextScopeRef;
        ComponentWrapper wrapper = (ComponentWrapper)this.components.get(name);
        if (wrapper != null && (wrapper.isAtLeast(WrapperState.WIRED) || !needInstance)) {
            return wrapper;
        }
        if (wrapper == null && this.next != null && (nextScopeRef = this.next.getComponent(name, componentType)) != null) {
            return nextScopeRef;
        }
        ComponentFactory factory = this.findFactory(name);
        if (wrapper == null) {
            if (factory == null) {
                return null;
            }
            wrapper = this.registerWrapper(name, true);
        }
        if (needInstance) {
            if (factory != null) {
                this.instantiateWrapper(wrapper, factory);
            } else {
                this.awaitWrapperState(wrapper, WrapperState.INSTANTIATED);
            }
            this.wireWrapper(wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentWrapper registerWrapper(String name, boolean manageLifecycle) {
        ComponentWrapper wrapper = new ComponentWrapper(this, name, manageLifecycle);
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING) {
                throw new IllegalLifecycleStateException("Cannot register components while the registry is not running");
            }
            ComponentWrapper existing = this.components.putIfAbsent(wrapper.name, wrapper);
            ComponentWrapper componentWrapper = existing != null ? existing : wrapper;
            return componentWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void instantiateWrapper(ComponentWrapper wrapper, ComponentFactory factory) {
        String name = wrapper.name;
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            this.awaitWrapperState(wrapper, WrapperState.INSTANTIATED);
            return;
        }
        try {
            this.doInstantiateWrapper(wrapper, factory, name);
        }
        catch (Throwable t) {
            this.commitWrapperStateChange(wrapper, WrapperState.INSTANTIATING, WrapperState.FAILED);
            throw t;
        }
    }

    private void doInstantiateWrapper(ComponentWrapper wrapper, ComponentFactory factory, String name) {
        Object instance;
        try {
            instance = factory.construct(name);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to construct component " + name + ", path " + String.valueOf(this.peekMutatorPath()), t);
        }
        if (instance instanceof ComponentAlias) {
            ComponentAlias alias = (ComponentAlias)instance;
            this.commitWrapperAliasChange(wrapper, alias, null, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
        } else {
            ComponentAccessor<Object> accessor = this.getMetadataForComponent(instance);
            this.commitWrapperInstanceChange(wrapper, instance, accessor, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
        }
    }

    private void wireWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.INSTANTIATED, WrapperState.WIRING)) {
            this.awaitWrapperState(wrapper, WrapperState.WIRED);
            return;
        }
        try {
            this.doWireWrapper(wrapper);
        }
        catch (Throwable t) {
            this.commitWrapperStateChange(wrapper, WrapperState.WIRING, WrapperState.FAILED);
            throw t;
        }
    }

    private void doWireWrapper(ComponentWrapper wrapper) {
        if (wrapper.instance instanceof ComponentAlias) {
            ComponentAlias alias = (ComponentAlias)wrapper.instance;
            String aliasTargetName = alias.getComponentName();
            ComponentRef targetRef = this.getComponent(aliasTargetName, Object.class);
            if (targetRef == null) {
                throw new RuntimeException("Alias " + wrapper.name + " target component is missing: " + aliasTargetName);
            }
            targetRef.wired();
            this.commitWrapperAliasChange(wrapper, alias, targetRef, WrapperState.WIRING, WrapperState.WIRED);
        } else {
            this.invokeInjection(wrapper.instance, wrapper.accessor, false);
            WrapperState wiredState = wrapper.accessor != null ? WrapperState.WIRED : WrapperState.STARTED;
            this.commitWrapperStateChange(wrapper, WrapperState.WIRING, wiredState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wireDependencies(Object target, boolean startDependencies) {
        String componentClassName = target.getClass().getName();
        this.pushMutatorPath("wireDependencies", componentClassName);
        try {
            ComponentAccessor<Object> accessor = this.moduleRepository.getComponentAccessor(componentClassName);
            this.invokeInjection(target, accessor, startDependencies);
        }
        finally {
            this.popMutatorPath();
        }
    }

    private ComponentFactory findFactory(String name) {
        String factoryName = this.moduleRepository.getFactoryName(name);
        if (factoryName == null) {
            return this.tryAutoInstantiation(name);
        }
        ComponentRef factoryRef = this.getComponent(factoryName, ComponentFactory.class);
        if (factoryRef != null) {
            return (ComponentFactory)factoryRef.running();
        }
        return null;
    }

    private void commitWrapperStateChange(ComponentWrapper wrapper, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, wrapper.instance, wrapper.accessor, wrapper.aliasTarget, expectedState, newState);
    }

    private void commitWrapperInstanceChange(ComponentWrapper wrapper, Object instance, ComponentAccessor<Object> accessor, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, instance, accessor, null, expectedState, newState);
    }

    private void commitWrapperAliasChange(ComponentWrapper wrapper, ComponentAlias alias, ComponentRef<?> targetRef, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, alias, null, targetRef, expectedState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWrapperChange(ComponentWrapper wrapper, Object instance, ComponentAccessor<Object> accessor, ComponentRef<?> aliasTargetRef, WrapperState expectedState, WrapperState newState) {
        this.lock.lock();
        try {
            if (wrapper.state != expectedState) {
                throw new IllegalLifecycleStateException("Component " + wrapper.name + " has wrong status: " + String.valueOf((Object)wrapper.state) + ", expected: " + String.valueOf((Object)expectedState));
            }
            wrapper.instance = instance;
            wrapper.accessor = accessor;
            wrapper.aliasTarget = aliasTargetRef;
            wrapper.state = newState;
            this.popMutatorPath();
            this.wrapperChangedStatus(wrapper.name, wrapper.state);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private ComponentFactory tryAutoInstantiation(String factoryName) {
        ComponentAccessor<Object> accessor = this.moduleRepository.getComponentAccessor(factoryName);
        if (accessor == null) {
            return null;
        }
        if (accessor.getScopeOrdinal() != null && !accessor.getScopeOrdinal().equals(this.scope.ordinal())) {
            return null;
        }
        Object autoInstance = accessor.newInstance();
        if (autoInstance == null) {
            return null;
        }
        return new ConstComponentFactory(autoInstance);
    }

    private void invokeInjection(Object target, ComponentAccessor<Object> accessor, boolean startDependencies) {
        try {
            if (accessor == null) {
                return;
            }
            accessor.wire(target, this.lookup, startDependencies);
            String superComponentClassName = accessor.getSuperAccessorName();
            if (superComponentClassName != null) {
                ComponentAccessor<Object> superAccessor = this.moduleRepository.getComponentAccessor(superComponentClassName);
                if (superAccessor == null) {
                    throw new RuntimeException("Component metadata not found for super class " + superComponentClassName);
                }
                this.invokeInjection(target, superAccessor, startDependencies);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inject dependencies for component class " + target.getClass().getName() + ", path " + String.valueOf(this.peekMutatorPath()), e);
        }
    }

    <T> T throwDependencyNotFound(String componentName) {
        throw new RuntimeException("Unable to construct dependency " + componentName + " in scope " + String.valueOf((Object)this.scope) + " for " + String.valueOf(this.peekMutatorPath()));
    }

    @Override
    public <T> ComponentRef<T> registerComponent(String componentName, T instance, boolean manageLifecycle) {
        ComponentAccessor<Object> accessor = this.getMetadataForComponent(instance);
        ComponentWrapper wrapper = this.registerWrapper(componentName, manageLifecycle);
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            throw new RuntimeException("Component " + componentName + " is already registered");
        }
        this.commitWrapperInstanceChange(wrapper, instance, accessor, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
        this.wireWrapper(wrapper);
        return wrapper;
    }

    private ComponentAccessor<Object> validateAccessor(ComponentAccessor<Object> accessor, Class<?> componentClass) {
        String className = componentClass.getName();
        if (accessor != null && !accessor.getScopeOrdinal().equals(Scopes.NONE.ordinal()) && !accessor.getScopeOrdinal().equals(this.scope.ordinal())) {
            throw new RuntimeException("Wrong registration scope " + String.valueOf((Object)this.scope) + " for component class " + className);
        }
        if (accessor == null && className.contains("$MockitoMock$")) {
            Class<?> mockedClass = componentClass.getSuperclass();
            return this.validateAccessor(this.moduleRepository.getComponentAccessor(mockedClass.getName()), mockedClass);
        }
        return accessor;
    }

    private ComponentAccessor<Object> getMetadataForComponent(Object component) {
        if (component == null) {
            return null;
        }
        Class<?> componentClass = component.getClass();
        ComponentAccessor<Object> accessor = this.moduleRepository.getComponentAccessor(componentClass.getName());
        return this.validateAccessor(accessor, componentClass);
    }

    @Override
    public void registerAlias(String aliasName, String targetComponentName, Class<?> targetComponentType) {
        ComponentWrapper wrapper = this.registerWrapper(aliasName, false);
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            throw new IllegalStateException("Cannot register alias " + aliasName + " with target " + targetComponentName + " as the name is already registered");
        }
        this.commitWrapperAliasChange(wrapper, ComponentAlias.of(targetComponentName), null, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicDependency(String ownerComponentName, String dependencyComponentName) {
        ComponentRef ref = this.getComponent0(ownerComponentName, Object.class, false);
        if (ref instanceof ComponentWrapper) {
            ComponentWrapper wrapper = (ComponentWrapper)ref;
            this.lock.lock();
            try {
                wrapper.addDynamicDependency(dependencyComponentName);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void replaceComponent(String componentName, Object newInstance, boolean manageLifecycle) {
        this.lock.lock();
        ComponentWrapper newWrapper = null;
        try {
            boolean canRunStart;
            ComponentAccessor<Object> accessor = this.getMetadataForComponent(newInstance);
            this.invokeInjection(newInstance, accessor, false);
            newWrapper = new ComponentWrapper(this, componentName, manageLifecycle);
            ComponentWrapper oldWrapper = this.components.put(componentName, newWrapper);
            this.tracker.removeComponent(componentName);
            this.prepareWrapperChange(newWrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING);
            boolean wantStarted = oldWrapper != null && oldWrapper.isRunning();
            boolean bl = canRunStart = manageLifecycle && accessor != null;
            if (wantStarted && canRunStart) {
                this.invokeStart(newInstance, accessor);
            }
            WrapperState state = wantStarted || !canRunStart ? WrapperState.STARTED : WrapperState.WIRED;
            this.commitWrapperInstanceChange(newWrapper, newInstance, accessor, WrapperState.INSTANTIATING, state);
        }
        catch (Throwable t) {
            if (newWrapper != null) {
                this.commitWrapperStateChange(newWrapper, WrapperState.INSTANTIATING, WrapperState.FAILED);
            }
            throw new RuntimeException("Unable to start replacement component " + String.valueOf(newInstance), t);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewire() {
        this.tracker.clear();
        this.lock.lock();
        try {
            if (this.status == ComponentStatus.TERMINATED) {
                this.status = ComponentStatus.RUNNING;
            }
            for (ComponentWrapper wrapper : this.components.values()) {
                if (wrapper.isAlias()) {
                    ComponentAlias alias = (ComponentAlias)wrapper.instance;
                    String aliasTargetName = alias.getComponentName();
                    ComponentRef targetRef = this.getComponent(aliasTargetName, Object.class);
                    if (targetRef == null) {
                        throw new RuntimeException("Alias " + wrapper.name + " target component is missing: " + aliasTargetName);
                    }
                    targetRef.wired();
                    wrapper.aliasTarget = targetRef;
                    continue;
                }
                this.invokeInjection(wrapper.instance, wrapper.accessor, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComponentRef<?>> getRegisteredComponents() {
        this.lock.lock();
        try {
            ArrayList<ComponentWrapper> list = new ArrayList<ComponentWrapper>(this.components.size());
            for (ComponentWrapper wrapper : this.components.values()) {
                list.add(wrapper);
            }
            ArrayList<ComponentWrapper> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList<String> componentsToStop;
        this.tracker.clear();
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING) {
                throw new IllegalStateException("Stopping is only allowed in the RUNNING state, current state is " + String.valueOf((Object)this.status) + "!");
            }
            componentsToStop = new ArrayList<String>(this.startedComponents);
            this.status = ComponentStatus.STOPPING;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        for (int i = componentsToStop.size() - 1; i >= 0; --i) {
            ComponentWrapper wrapper = (ComponentWrapper)this.components.get(componentsToStop.get(i));
            if (wrapper == null) continue;
            this.stopWrapper(wrapper);
        }
        this.lock.lock();
        try {
            this.startedComponents.clear();
            this.removeVolatileComponents();
            this.status = ComponentStatus.TERMINATED;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasComponentAccessor(String componentClassName) {
        return this.moduleRepository.getComponentAccessor(componentClassName) != null;
    }

    @GuardedBy(value="lock")
    private void removeVolatileComponents() {
        Iterator it = this.components.values().iterator();
        while (it.hasNext()) {
            boolean survivesRestarts;
            ComponentWrapper wrapper = (ComponentWrapper)it.next();
            boolean bl = survivesRestarts = wrapper.accessor != null && wrapper.accessor.getSurvivesRestarts();
            if (wrapper.manageLifecycle && !survivesRestarts) {
                if (log.isTraceEnabled()) {
                    log.tracef("Removing component %s in state %s", wrapper.name, (Object)wrapper.state);
                }
                it.remove();
                continue;
            }
            if (wrapper.manageLifecycle && wrapper.state == WrapperState.STOPPED) {
                wrapper.state = WrapperState.INSTANTIATED;
            }
            if (!log.isTraceEnabled()) continue;
            log.tracef("Keeping component %s in state %s", wrapper.name, (Object)wrapper.state);
        }
    }

    private void startWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.WIRED, WrapperState.STARTING)) {
            this.awaitWrapperState(wrapper, WrapperState.STARTED);
            return;
        }
        try {
            this.doStartWrapper(wrapper);
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.STARTED);
        }
        catch (CacheException e) {
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.FAILED);
            throw e;
        }
        catch (Throwable t) {
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.FAILED);
            throw Log.CONFIG.componentFailedToStart(wrapper.toString(), t);
        }
    }

    private void doStartWrapper(ComponentWrapper wrapper) throws Exception {
        if (wrapper.aliasTarget != null) {
            wrapper.aliasTarget.running();
            return;
        }
        if (wrapper.accessor == null) {
            throw new IllegalStateException("Components without metadata should go directly to RUNNING state");
        }
        this.startDependencies(wrapper);
        if (!wrapper.manageLifecycle) {
            return;
        }
        this.logStartedComponent(wrapper);
        this.invokeStart(wrapper.instance, wrapper.accessor);
    }

    private void invokeStart(Object instance, ComponentAccessor<Object> accessor) throws Exception {
        if (accessor.getSuperAccessorName() != null) {
            this.invokeStart(instance, this.moduleRepository.getComponentAccessor(accessor.getSuperAccessorName()));
        }
        accessor.start(instance);
    }

    private void logStartedComponent(ComponentWrapper wrapper) {
        this.lock.lock();
        try {
            this.startedComponents.add(wrapper.getName());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startDependencies(ComponentWrapper wrapper) {
        ComponentRef dependency;
        ComponentAccessor<Object> accessor = wrapper.accessor;
        while (true) {
            for (String dependencyName : accessor.getEagerDependencies()) {
                dependency = this.getComponent(dependencyName, Object.class);
                if (dependency == null) continue;
                dependency.running();
            }
            if (accessor.getSuperAccessorName() == null) break;
            accessor = this.moduleRepository.getComponentAccessor(accessor.getSuperAccessorName());
        }
        ComponentPath remainingDependencies = wrapper.dynamicDependencies;
        while (remainingDependencies != null) {
            String componentName = remainingDependencies.name;
            dependency = this.getComponent(componentName, Object.class);
            if (dependency != null) {
                dependency.running();
            }
            remainingDependencies = remainingDependencies.next;
        }
    }

    private void stopWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.STARTED, WrapperState.STOPPING) && !this.prepareWrapperChange(wrapper, WrapperState.FAILED, WrapperState.STOPPING)) {
            return;
        }
        try {
            this.doStopWrapper(wrapper);
        }
        catch (Throwable t) {
            log.errorf(t, "Error stopping component %s", wrapper.name);
        }
        finally {
            this.commitWrapperStateChange(wrapper, WrapperState.STOPPING, WrapperState.STOPPED);
        }
    }

    private void doStopWrapper(ComponentWrapper wrapper) throws Exception {
        if (!wrapper.manageLifecycle || wrapper.accessor == null) {
            return;
        }
        this.invokeStop(wrapper.instance, wrapper.accessor);
    }

    private void invokeStop(Object instance, ComponentAccessor<Object> accessor) throws Exception {
        accessor.stop(instance);
        String superComponentClassName = accessor.getSuperAccessorName();
        if (superComponentClassName != null) {
            this.invokeStop(instance, this.moduleRepository.getComponentAccessor(superComponentClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareWrapperChange(ComponentWrapper wrapper, WrapperState expectedState, WrapperState newState) {
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING && newState.isBefore(WrapperState.STOPPING)) {
                throw new IllegalLifecycleStateException("Cannot wire or start components while the registry is not running");
            }
            if (wrapper.state != expectedState) {
                boolean bl = false;
                return bl;
            }
            wrapper.state = newState;
            String componentClassName = wrapper.instance != null ? wrapper.instance.getClass().getName() : null;
            String name = this.pushMutatorPath(wrapper.name, componentClassName);
            this.wrapperChangedStatus(name, wrapper.state);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void wrapperChangedStatus(String name, WrapperState state) {
        if (this.tracker != null) {
            switch (state.ordinal()) {
                case 0: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 1: {
                    this.tracker.instantiating(name);
                    break;
                }
                case 2: {
                    this.tracker.instantiated(name);
                    break;
                }
                case 3: {
                    this.tracker.wiring(name);
                    break;
                }
                case 4: {
                    this.tracker.wired(name);
                    break;
                }
                case 5: {
                    this.tracker.starting(name);
                    break;
                }
                case 6: {
                    this.tracker.started(name);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Changed status of " + name + " to " + String.valueOf((Object)state), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitWrapperState(ComponentWrapper wrapper, WrapperState expectedState) {
        this.lock.lock();
        try {
            ComponentPath currentComponentPath;
            String name = wrapper.name;
            if (wrapper.state == WrapperState.EMPTY) {
                throw new RuntimeException("Component " + name + " is missing a strong (non-ComponentRef) reference: waiting to become " + String.valueOf((Object)expectedState) + " but it has not been instantiated yet");
            }
            if (wrapper.state.isBefore(expectedState) && (currentComponentPath = this.peekMutatorPath()) != null && currentComponentPath.contains(name)) {
                String className = wrapper.instance != null ? wrapper.instance.getClass().getName() : null;
                throw new RuntimeException("Dependency cycle detected, please use ComponentRef<T> to break the cycle in path " + String.valueOf(new ComponentPath(name, className, this.peekMutatorPath())));
            }
            while (this.status == ComponentStatus.RUNNING && wrapper.isBefore(expectedState)) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalLifecycleStateException("Interrupted while waiting for component " + name + " to start");
                }
            }
            wrapper.expectState(expectedState, WrapperState.STOPPING);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String pushMutatorPath(String name, String className) {
        ComponentPath currentPath = (ComponentPath)this.mutatorThreads.get(Thread.currentThread());
        this.mutatorThreads.put(Thread.currentThread(), new ComponentPath(name, className, currentPath));
        return name;
    }

    private void popMutatorPath() {
        ComponentPath currentPath = (ComponentPath)this.mutatorThreads.get(Thread.currentThread());
        if (currentPath.next != null) {
            this.mutatorThreads.put(Thread.currentThread(), currentPath.next);
        } else {
            this.mutatorThreads.remove(Thread.currentThread());
        }
    }

    private ComponentPath peekMutatorPath() {
        return (ComponentPath)this.mutatorThreads.get(Thread.currentThread());
    }

    public String toString() {
        return "BasicComponentRegistryImpl{scope=" + String.valueOf((Object)this.scope) + ", size=" + this.components.size() + "}";
    }

    static class ComponentWrapper
    implements ComponentRef {
        private final BasicComponentRegistryImpl registry;
        private final String name;
        private final boolean manageLifecycle;
        private volatile WrapperState state;
        private volatile ComponentPath dynamicDependencies;
        private volatile Object instance;
        private volatile ComponentAccessor<Object> accessor;
        private volatile ComponentRef<?> aliasTarget;

        ComponentWrapper(BasicComponentRegistryImpl registry, String name, boolean manageLifecycle) {
            this.registry = registry;
            this.name = name;
            this.manageLifecycle = manageLifecycle;
            this.state = WrapperState.EMPTY;
        }

        public Object running() {
            if (!this.isRunning()) {
                this.wire();
                this.registry.startWrapper(this);
                this.expectState(WrapperState.STARTED, WrapperState.STOPPING);
            }
            return this.aliasTarget != null ? this.aliasTarget.running() : this.instance;
        }

        public Object wired() {
            if (!this.isWired()) {
                this.wire();
            }
            return this.aliasTarget != null ? this.aliasTarget.wired() : this.instance;
        }

        public void wire() {
            if (!this.isAtLeast(WrapperState.INSTANTIATED)) {
                ComponentFactory factory = this.registry.findFactory(this.name);
                this.registry.instantiateWrapper(this, factory);
            }
            this.registry.wireWrapper(this);
        }

        @Override
        public boolean isRunning() {
            return this.state == WrapperState.STARTED;
        }

        @Override
        public boolean isWired() {
            return this.isAtLeast(WrapperState.WIRED) && this.isBefore(WrapperState.STOPPING);
        }

        @Override
        public boolean isAlias() {
            return this.instance instanceof ComponentAlias;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void expectState(WrapperState firstAllowedState, WrapperState firstDisallowedState) {
            WrapperState localState = this.state;
            if (localState.isBefore(firstAllowedState)) {
                throw new IllegalLifecycleStateException("Component " + this.name + " is not yet " + String.valueOf((Object)firstAllowedState));
            }
            if (localState.isAtLeast(firstDisallowedState)) {
                throw new IllegalLifecycleStateException("Component " + this.name + " is already " + String.valueOf((Object)localState));
            }
        }

        boolean isAtLeast(WrapperState expectedState) {
            return this.state.isAtLeast(expectedState);
        }

        boolean isBefore(WrapperState expectedState) {
            return this.state.isBefore(expectedState);
        }

        @GuardedBy(value="BasicComponentRegistryImpl.lock")
        void addDynamicDependency(String subComponentName) {
            this.dynamicDependencies = new ComponentPath(subComponentName, null, this.dynamicDependencies);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ComponentWrapper{").append("name=").append(this.name);
            if (this.aliasTarget != null) {
                sb.append(", aliasTarget=").append(this.aliasTarget);
            } else {
                sb.append(", instance=").append(this.instance);
            }
            sb.append(", status=").append((Object)this.state);
            sb.append('}');
            return sb.toString();
        }
    }

    static enum WrapperState {
        EMPTY,
        INSTANTIATING,
        INSTANTIATED,
        WIRING,
        WIRED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;


        boolean isAtLeast(WrapperState other) {
            return this.ordinal() >= other.ordinal();
        }

        boolean isBefore(WrapperState other) {
            return this.ordinal() < other.ordinal();
        }
    }

    static class ComponentPath {
        final String name;
        final String className;
        final ComponentPath next;

        ComponentPath(String name, String className, ComponentPath next) {
            this.name = name;
            this.className = className;
            this.next = next;
        }

        public boolean contains(String name) {
            ComponentPath path = this;
            while (path != null) {
                if (path.name.equals(name)) {
                    return true;
                }
                path = path.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean firstIteration = true;
            ComponentPath path = this;
            while (path != null) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    sb.append("\n  << ");
                }
                sb.append(path.name);
                if (path.className != null) {
                    sb.append(" (a ").append(path.className).append(")");
                }
                path = path.next;
            }
            return sb.toString();
        }
    }

    private static class ConstComponentFactory
    implements ComponentFactory {
        private final Object autoInstance;

        public ConstComponentFactory(Object autoInstance) {
            this.autoInstance = autoInstance;
        }

        @Override
        public Object construct(String componentName) {
            return this.autoInstance;
        }
    }
}

