/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NullAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.ConcurrentBlockingRingBuffer;
import org.jgroups.util.ConcurrentLinkedBlockingQueue;
import org.jgroups.util.FastArray;
import org.jgroups.util.Runner;
import org.jgroups.util.Util;

public class PerDestinationBundler
extends BaseBundler
implements Runnable {
    protected Address local_addr;
    protected final Map<Address, SendBuffer> dests = Util.createConcurrentMap();
    protected static final Address NULL = new NullAddress();
    protected Runner single_thread_runner;
    protected static final String THREAD_NAME = "pd-bundler";
    protected final Condition not_empty = this.lock.newCondition();
    @ManagedAttribute(description="Total number of messages in all queues")
    protected final AtomicInteger msgs_available = new AtomicInteger();

    public boolean isRunning() {
        return this.single_thread_runner != null && this.single_thread_runner.isRunning();
    }

    @Override
    @ManagedAttribute(description="Size of the queue (if available")
    public int getQueueSize() {
        return -1;
    }

    @Override
    @ManagedAttribute(description="The number of unsent messages in the bundler")
    public int size() {
        return this.dests.values().stream().map(SendBuffer::size).reduce(0, Integer::sum);
    }

    @ManagedOperation(description="Dumps all sendbuffers")
    public String dump() {
        return this.dests.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), ((SendBuffer)e.getValue()).dump())).collect(Collectors.joining("\n"));
    }

    @ManagedOperation(description="Shows the active threads")
    public String active() {
        return this.dests.entrySet().stream().map(e -> String.format("dest: %s alive=%b", e.getKey(), ((SendBuffer)e.getValue()).isThreadAlive())).collect(Collectors.joining("\n"));
    }

    @ManagedOperation(description="Shows all destinations")
    public String dests() {
        return this.dests.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    @Override
    public void init(TP transport) {
        TCP tcp;
        int size;
        super.init(transport);
        if (transport instanceof TCP && (size = (tcp = (TCP)transport).getBufferedOutputStreamSize()) < this.max_size) {
            int new_size = this.max_size + 4;
            this.log.warn("buffered_output_stream_size adjusted from %,d -> %,d", size, new_size);
            tcp.setBufferedOutputStreamSize(new_size);
        }
    }

    @Override
    public void start() {
        super.start();
        this.local_addr = Objects.requireNonNull(this.transport.getAddress());
        TP tP = this.transport;
        if (tP instanceof TCP) {
            TCP tcp = (TCP)tP;
            tcp.useLockToSend(!this.use_single_sender_thread);
        }
        if (this.use_single_sender_thread) {
            if (this.single_thread_runner == null) {
                this.single_thread_runner = new Runner(this.transport.getThreadFactory(), THREAD_NAME, this, null).joinTimeout(0L);
            }
            this.single_thread_runner.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.dests.values().forEach(SendBuffer::stop);
        this.dests.clear();
        Util.close((Closeable)this.single_thread_runner);
    }

    @Override
    public void send(Message msg) throws Exception {
        int old_val;
        boolean success;
        Address dest;
        SendBuffer buf;
        if (this.single_thread_runner != null && !this.single_thread_runner.isRunning()) {
            return;
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if ((buf = this.dests.get(dest = msg.dest() == null ? NULL : msg.dest())) == null) {
            buf = this.dests.computeIfAbsent(dest, k -> new SendBuffer(msg.dest()));
            buf.start();
        }
        if ((success = buf.send(msg)) && this.use_single_sender_thread && (old_val = this.msgs_available.getAndIncrement()) == 0) {
            this.signalNotEmpty();
        }
    }

    @Override
    public void run() {
        int removed_msgs = 0;
        for (SendBuffer buf : this.dests.values()) {
            int removed = buf.removeAndSend(true);
            removed_msgs += removed;
        }
        if (removed_msgs > 0) {
            this.msgs_available.addAndGet(-removed_msgs);
            return;
        }
        if (this.msgs_available.get() == 0) {
            this.waitUntilMessagesAreAvailable();
        }
    }

    @Override
    public void viewChange(View view) {
        List<Address> mbrs = view.getMembers();
        mbrs.stream().filter(dest -> !this.dests.containsKey(dest)).forEach(dest -> {
            SendBuffer buf = this.dests.get(dest);
            if (buf == null) {
                buf = this.dests.computeIfAbsent((Address)dest, k -> new SendBuffer((Address)dest));
                buf.start();
            }
        });
        this.dests.entrySet().stream().filter(e -> e.getKey() != NULL && !mbrs.contains(e.getKey())).forEach(e -> {
            ((SendBuffer)e.getValue()).stop();
            this.dests.remove(e.getKey());
        });
    }

    protected void signalNotEmpty() {
        this.lock.lock();
        try {
            this.not_empty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void waitUntilMessagesAreAvailable() {
        this.lock.lock();
        try {
            while (this.msgs_available.get() == 0) {
                try {
                    this.not_empty.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected class SendBuffer
    implements Runnable {
        private final Address dest;
        private final FastArray<Message> msgs = new FastArray(32).increment(64);
        private final Lock lock = new ReentrantLock(false);
        private final BlockingQueue<Message> queue;
        private final FastArray<Message> remove_queue;
        private final ByteArrayDataOutputStream output;
        private Runner sendbuf_runner;
        private long count;

        public String dump() {
            return String.format("msgs cap: %,d, remove-q cap: %,d", this.msgs.capacity(), this.remove_queue.capacity());
        }

        public SendBuffer(Address dest) {
            this.output = new ByteArrayDataOutputStream(PerDestinationBundler.this.max_size + 5);
            this.dest = dest;
            boolean block_on_empty = !PerDestinationBundler.this.use_single_sender_thread;
            this.queue = PerDestinationBundler.this.use_ringbuffer ? new ConcurrentBlockingRingBuffer<Message>(PerDestinationBundler.this.capacity, block_on_empty, false) : new ConcurrentLinkedBlockingQueue<Message>(PerDestinationBundler.this.capacity, block_on_empty, false);
            if (PerDestinationBundler.this.remove_queue_capacity == 0) {
                PerDestinationBundler.this.remove_queue_capacity = Math.max(PerDestinationBundler.this.capacity / 8, 1024);
            }
            this.remove_queue = new FastArray(PerDestinationBundler.this.remove_queue_capacity);
        }

        public boolean isThreadAlive() {
            return this.sendbuf_runner != null && this.sendbuf_runner.getThread().isAlive();
        }

        public SendBuffer start() {
            if (!PerDestinationBundler.this.use_single_sender_thread) {
                this.lock.lock();
                try {
                    if (this.sendbuf_runner == null) {
                        this.sendbuf_runner = new Runner(PerDestinationBundler.this.transport.getThreadFactory(), PerDestinationBundler.THREAD_NAME, this, null).setJoinTimeout(0L);
                    }
                    this.sendbuf_runner.start();
                }
                finally {
                    this.lock.unlock();
                }
            }
            return this;
        }

        public void stop() {
            Util.close((Closeable)this.sendbuf_runner);
        }

        @Override
        public void run() {
            try {
                Message msg = this.queue.take();
                if (msg == null) {
                    return;
                }
                this.addAndSendIfSizeExceeded(msg);
                this.removeAndSend(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected int removeAndSend(boolean execute_only_once) {
            int removed_msgs = 0;
            do {
                this.remove_queue.clear(false);
                int num_msgs = this.queue.drainTo(this.remove_queue, PerDestinationBundler.this.remove_queue_capacity);
                if (num_msgs <= 0) break;
                removed_msgs += num_msgs;
                PerDestinationBundler.this.avg_remove_queue_size.add(num_msgs);
                this.remove_queue.forEach(this::addAndSendIfSizeExceeded);
            } while (!execute_only_once);
            if (this.count > 0L) {
                if (PerDestinationBundler.this.transport.statsEnabled()) {
                    PerDestinationBundler.this.avg_fill_count.add(this.count);
                }
                this.sendBundledMessages();
                PerDestinationBundler.this.num_sends_because_no_msgs.increment();
            }
            return removed_msgs;
        }

        protected void addAndSendIfSizeExceeded(Message msg) {
            int size = msg.size();
            if (this.count + (long)size >= (long)PerDestinationBundler.this.max_size) {
                if (PerDestinationBundler.this.transport.statsEnabled()) {
                    PerDestinationBundler.this.avg_fill_count.add(this.count);
                }
                this.sendBundledMessages();
                PerDestinationBundler.this.num_sends_because_full_queue.increment();
            }
            this.addMessage(msg, size);
        }

        protected void addMessage(Message msg, int size) {
            this.msgs.add(msg);
            this.count += (long)size;
        }

        protected boolean send(Message msg) throws Exception {
            if (this.sendbuf_runner != null && !this.sendbuf_runner.isRunning()) {
                return false;
            }
            if (this.queue.offer(msg)) {
                return true;
            }
            PerDestinationBundler.this.num_drops_on_full_queue.increment();
            return false;
        }

        protected void sendBundledMessages() {
            if (this.msgs.isEmpty()) {
                return;
            }
            this.sendMessages(this.dest, PerDestinationBundler.this.local_addr, this.msgs);
            this.msgs.clear(false);
            this.count = 0L;
        }

        protected void sendMessages(Address dest, Address src, List<Message> list) {
            long start = PerDestinationBundler.this.transport.statsEnabled() ? System.nanoTime() : 0L;
            try {
                this.output.position(0);
                int size = list.size();
                if (size == 1) {
                    PerDestinationBundler.this.sendSingle(dest, list.get(0), this.output);
                } else {
                    PerDestinationBundler.this.sendMultiple(dest, src, list, this.output);
                }
                if (PerDestinationBundler.this.transport.statsEnabled()) {
                    PerDestinationBundler.this.avg_send_time.add(System.nanoTime() - start);
                }
                PerDestinationBundler.this.total_msgs_sent.add(size);
            }
            catch (Throwable ex) {
                if (PerDestinationBundler.this.suppress_log_timeout <= 0L) {
                    PerDestinationBundler.this.log.trace("%s: failed sending message to %s: %s", PerDestinationBundler.this.transport.getAddress(), dest, ex.getMessage());
                }
                PerDestinationBundler.this.suppress_log.warn(dest, PerDestinationBundler.this.suppress_log_timeout, "%s: failed sending message to %s: %s", PerDestinationBundler.this.transport.getAddress(), dest, ex.getMessage());
            }
        }

        public String toString() {
            return String.format("%d msgs", this.queue.size());
        }

        protected int size() {
            this.lock.lock();
            try {
                int n = this.msgs.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

