/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.jgroups.util.Util;

public class IntHashMap<T> {
    protected T[] table;
    protected int size;

    public IntHashMap(int highest_key) {
        this.table = new Object[Util.nonNegativeValue(highest_key) + 1];
    }

    public int getCapacity() {
        return this.table.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(int k) {
        return k + 1 <= this.table.length && this.table[k] != null;
    }

    public T get(int k) {
        return k + 1 <= this.table.length ? (T)this.table[k] : null;
    }

    public IntHashMap<T> put(int key, T value) {
        this.checkCapacity(key);
        T val = this.table[key];
        if (val != null) {
            throw new IllegalStateException(String.format("duplicate key %d (value: %s)", key, val));
        }
        this.table[key] = Objects.requireNonNull(value);
        ++this.size;
        return this;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (int i = 0; i < this.table.length; ++i) {
            T el = this.table[i];
            if (el == null) continue;
            sj.add(i + "=" + String.valueOf(el));
        }
        return sj.toString();
    }

    protected IntHashMap<T> checkCapacity(int key) {
        if (key + 1 > this.table.length) {
            int new_len = key + 1;
            this.table = Arrays.copyOf(this.table, new_len);
        }
        return this;
    }
}

