/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ObjectWrapperPrimitive;
import org.jgroups.util.Util;

public class ObjectWrapperSerializable
extends ObjectWrapperPrimitive {
    protected ByteArray serialized;

    public ObjectWrapperSerializable() {
    }

    public ObjectWrapperSerializable(Object obj) {
        super(obj);
    }

    @Override
    public synchronized ObjectWrapperSerializable setObject(Object obj) {
        super.setObject(obj);
        this.serialized = null;
        return this;
    }

    public synchronized ByteArray getSerialized() {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            this.serialized = Util.objectToBuffer(this.obj);
            return this.serialized;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getLength() {
        return this.getSerialized().length();
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.obj, this.serialized != null ? "( " + this.serialized.length() + " bytes)" : "");
    }

    @Override
    public int serializedSize() {
        int retval = 4;
        if (this.obj == null) {
            return retval;
        }
        return retval + this.getLength();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.obj != null) {
            ByteArray arr = this.getSerialized();
            out.writeInt(arr.length());
            out.write(arr.array(), 0, arr.length());
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        if (len == -1) {
            return;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp, 0, len);
        this.serialized = new ByteArray(tmp);
        this.obj = Util.objectFromBuffer(this.serialized, null);
    }
}

