/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import org.jgroups.logging.Log;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;

public class Runner
implements Runnable,
Closeable {
    protected final ThreadFactory factory;
    protected String thread_name;
    protected final Runnable function;
    protected final Runnable stop_function;
    protected volatile State state = State.stopped;
    protected Thread thread;
    protected boolean daemon;
    protected long join_timeout = 100L;
    protected Log log;

    public Runner(String name, Runnable function, Runnable stop_function) {
        this(new DefaultThreadFactory(name, true, true), name, function, stop_function);
    }

    public Runner(ThreadFactory factory, String thread_name, Runnable function, Runnable stop_function) {
        this.factory = factory;
        this.thread_name = thread_name;
        this.function = function;
        this.stop_function = stop_function;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.state == State.running;
    }

    public boolean running() {
        return this.state == State.running;
    }

    public State state() {
        return this.state;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public Runner daemon(boolean d) {
        this.daemon = d;
        return this;
    }

    public String threadName() {
        return this.thread_name;
    }

    public Runner threadName(String n) {
        this.thread_name = n;
        if (this.thread != null) {
            this.thread.setName(n);
        }
        return this;
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public Runner setJoinTimeout(long t) {
        this.join_timeout = t;
        return this;
    }

    public Runner joinTimeout(long t) {
        return this.setJoinTimeout(t);
    }

    public Log log() {
        return this.log;
    }

    public Runner log(Log l) {
        this.log = l;
        return this;
    }

    public synchronized Runner start() {
        boolean rc = this.state(State.running);
        if (!rc) {
            return this;
        }
        String name = this.thread_name != null ? this.thread_name : "runner";
        Thread thread = this.thread = this.factory != null ? this.factory.newThread(this, name) : new Thread((Runnable)this, name);
        if (this.thread.getClass() == Thread.class) {
            this.thread.setDaemon(this.daemon);
        }
        this.thread.start();
        return this;
    }

    public synchronized Runner stop() {
        boolean rc = this.state(State.stopping);
        if (!rc) {
            return this;
        }
        Thread tmp = this.thread;
        if (tmp != null) {
            tmp.interrupt();
            if (this.join_timeout > 0L) {
                try {
                    tmp.join(this.join_timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.runStopFuntion();
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.state == State.running) {
                try {
                    this.function.run();
                }
                catch (Throwable throwable) {}
                continue;
            }
            Runner runner = this;
            synchronized (runner) {
                switch (this.state) {
                    case stopped: 
                    case stopping: {
                        if (this.state == State.stopping) {
                            this.state(State.stopped);
                        }
                        return;
                    }
                }
            }
        }
    }

    public String toString() {
        return String.format("%s[%s]", new Object[]{this.thread != null ? this.thread.getName() : "", this.state});
    }

    protected boolean state(State new_state) {
        switch (this.state) {
            case stopped: {
                return switch (new_state) {
                    default -> throw new IncompatibleClassChangeError();
                    case State.stopped, State.stopping -> false;
                    case State.running -> {
                        this.state = new_state;
                        yield true;
                    }
                };
            }
            case stopping: {
                return switch (new_state) {
                    default -> throw new IncompatibleClassChangeError();
                    case State.stopped -> {
                        this.state = new_state;
                        yield false;
                    }
                    case State.stopping -> false;
                    case State.running -> {
                        this.state = new_state;
                        yield false;
                    }
                };
            }
            case running: {
                return switch (new_state) {
                    default -> throw new IncompatibleClassChangeError();
                    case State.stopped, State.running -> false;
                    case State.stopping -> {
                        this.state = new_state;
                        yield true;
                    }
                };
            }
        }
        throw new IllegalStateException(String.format("illegal transition from %s -> %s", new Object[]{this.state, new_state}));
    }

    protected void runStopFuntion() {
        block3: {
            try {
                if (this.stop_function != null) {
                    this.stop_function.run();
                }
            }
            catch (Throwable t) {
                if (this.log == null) break block3;
                this.log.error("%s: failed running stop_function: %s", this.thread_name, t.getMessage());
            }
        }
    }

    public static enum State {
        stopped,
        stopping,
        running;

    }
}

