/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GitHubAuthenticationOptions {
    public static final String DEFAULT_GITHUB_AUTHENTICATION_PATH = "github";
    private final String path;
    private final Supplier<String> tokenSupplier;

    private GitHubAuthenticationOptions(Supplier<String> tokenSupplier, String path) {
        this.tokenSupplier = tokenSupplier;
        this.path = path;
    }

    public static GithubAuthenticationOptionsBuilder builder() {
        return new GithubAuthenticationOptionsBuilder();
    }

    public Supplier<String> getTokenSupplier() {
        return this.tokenSupplier;
    }

    public String getPath() {
        return this.path;
    }

    public static class GithubAuthenticationOptionsBuilder {
        private String path = "github";
        @Nullable
        private Supplier<String> tokenSupplier;

        public GithubAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public GithubAuthenticationOptionsBuilder token(String token) {
            Assert.hasText((String)token, (String)"Token must not be empty");
            return this.tokenSupplier(() -> token);
        }

        public GithubAuthenticationOptionsBuilder tokenSupplier(Supplier<String> tokenSupplier) {
            Assert.notNull(tokenSupplier, (String)"Token supplier must not be null");
            this.tokenSupplier = tokenSupplier;
            return this;
        }

        public GitHubAuthenticationOptions build() {
            Assert.notNull(this.tokenSupplier, (String)"Token must not be null");
            return new GitHubAuthenticationOptions(this.tokenSupplier, this.path);
        }
    }
}

