/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.mapping;

import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.keyvalue.core.mapping.AnnotationBasedKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.repository.mapping.Secret;
import org.springframework.vault.repository.mapping.SimpleClassNameKeySpaceResolver;
import org.springframework.vault.repository.mapping.VaultPersistentEntity;
import org.springframework.vault.repository.mapping.VaultPersistentProperty;

public class BasicVaultPersistentEntity<T>
extends BasicKeyValuePersistentEntity<T, VaultPersistentProperty>
implements VaultPersistentEntity<T> {
    private static final ValueExpressionParser PARSER = ValueExpressionParser.create();
    private final String backend;
    @Nullable
    private final ValueExpression backendExpression;

    public BasicVaultPersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver) {
        super(information, type -> {
            if (keySpaceResolver != null) {
                return keySpaceResolver.resolveKeySpace(type);
            }
            String keyspace = AnnotationBasedKeySpaceResolver.INSTANCE.resolveKeySpace(type);
            if (StringUtils.hasText((String)keyspace)) {
                return null;
            }
            return SimpleClassNameKeySpaceResolver.INSTANCE.resolveKeySpace(type);
        });
        Secret annotation = (Secret)this.findAnnotation(Secret.class);
        if (annotation != null && StringUtils.hasText((String)annotation.backend())) {
            this.backend = annotation.backend();
            this.backendExpression = BasicVaultPersistentEntity.detectExpression(this.backend);
        } else {
            this.backend = "secret";
            this.backendExpression = null;
        }
    }

    @Nullable
    private static ValueExpression detectExpression(String potentialExpression) {
        ValueExpression expression = PARSER.parse(potentialExpression);
        return expression.isLiteral() ? null : expression;
    }

    public String getKeySpace() {
        return "%s/%s".formatted(this.getSecretBackend(), super.getKeySpace());
    }

    @Override
    public String getSecretBackend() {
        return this.backendExpression == null ? this.backend : ObjectUtils.nullSafeToString((Object)this.backendExpression.evaluate(this.getValueEvaluationContext(null, this.backendExpression.getExpressionDependencies())));
    }
}

