/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.support.KeystoreUtil;
import org.springframework.vault.support.PemObject;

public class Certificate {
    private final String serialNumber;
    private final String certificate;
    private final String issuingCaCertificate;
    private final List<String> caChain;
    @Nullable
    private final Instant revocationTime;

    Certificate(@JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="issuing_ca") String issuingCaCertificate, @JsonProperty(value="ca_chain") List<String> caChain, @Nullable @JsonProperty(value="revocation_time") Long revocationTime) {
        this.serialNumber = serialNumber;
        this.certificate = certificate;
        this.issuingCaCertificate = issuingCaCertificate;
        this.caChain = caChain;
        this.revocationTime = revocationTime != null ? Instant.ofEpochMilli(revocationTime * 1000L) : null;
    }

    public static Certificate of(String serialNumber, String certificate, String issuingCaCertificate) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        return new Certificate(serialNumber, certificate, issuingCaCertificate, List.of(), null);
    }

    public static Certificate of(String serialNumber, String certificate, String issuingCaCertificate, List<String> caChain) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.notNull(caChain, (String)"CA chain must not be null");
        return new Certificate(serialNumber, certificate, issuingCaCertificate, caChain, null);
    }

    public static Certificate of(String serialNumber, String certificate, String issuingCaCertificate, List<String> caChain, Long revocationTime) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.notNull(caChain, (String)"CA chain must not be null");
        Assert.notNull((Object)revocationTime, (String)"Revocation time");
        return new Certificate(serialNumber, certificate, issuingCaCertificate, caChain, revocationTime);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getIssuingCaCertificate() {
        return this.issuingCaCertificate;
    }

    public X509Certificate getX509Certificate() {
        return this.doGetCertificate(this.getCertificate());
    }

    public X509Certificate getX509IssuerCertificate() {
        return this.doGetCertificate(this.getIssuingCaCertificate());
    }

    private X509Certificate doGetCertificate(String cert) {
        try {
            List<X509Certificate> certificates = Certificate.getCertificates(cert);
            if (certificates.isEmpty()) {
                throw new IllegalStateException("No certificate found");
            }
            return certificates.get(0);
        }
        catch (CertificateException e) {
            throw new VaultException("Cannot create Certificate from certificate", e);
        }
    }

    public KeyStore createTrustStore() {
        return this.createTrustStore(false);
    }

    public KeyStore createTrustStore(boolean includeCaChain) {
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(this.getX509Certificate());
            if (includeCaChain) {
                certificates.addAll(this.getX509IssuerCertificates());
            } else {
                certificates.add(this.getX509IssuerCertificate());
            }
            return KeystoreUtil.createKeyStore(certificates.toArray(new X509Certificate[0]));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
    }

    static List<X509Certificate> getCertificates(String certificates) throws CertificateException {
        Assert.hasText((String)certificates, (String)"Certificates must not be empty");
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(1);
        if (PemObject.isPemEncoded(certificates)) {
            List<PemObject> pemObjects = PemObject.parse(certificates);
            for (PemObject pemObject : pemObjects) {
                if (!pemObject.isCertificate()) continue;
                result.add(pemObject.getCertificate());
            }
        } else {
            result.addAll(KeystoreUtil.getCertificates(Base64.getDecoder().decode(certificates)));
        }
        return result;
    }

    public List<X509Certificate> getX509IssuerCertificates() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String data : this.caChain) {
            try {
                certificates.addAll(Certificate.getCertificates(data));
            }
            catch (CertificateException e) {
                throw new VaultException("Cannot create Certificate from issuing CA certificate", e);
            }
        }
        return certificates;
    }

    @Nullable
    public Instant getRevocationTime() {
        return this.revocationTime;
    }

    public boolean isRevoked() {
        return this.revocationTime != null;
    }
}

