/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.semver.VersionRange;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.xlplatform.utils.Strings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="applicationDependencies")
@ApplicableTo(value={PropertyKind.MAP_STRING_STRING})
public @interface ApplicationDependenciesFormat {
    public static final String DEFAULT_MESSAGE_WRONG_RANGE = "Value(s) '%s' do not have correct version range format (e.g. \"1.0\" or \"[2, 3)\")";
    public static final String DEFAULT_MESSAGE_WRONG_APPLICATION = "Application names should be used instead of paths: '%s'";

    public String messageWrongRange() default "Value(s) '%s' do not have correct version range format (e.g. \"1.0\" or \"[2, 3)\")";

    public String messageWrongApplication() default "Application names should be used instead of paths: '%s'";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Map<String, String>> {
        private String messageWrongRange = "Value(s) '%s' do not have correct version range format (e.g. \"1.0\" or \"[2, 3)\")";
        private String messageWrongApplication = "Application names should be used instead of paths: '%s'";

        @Override
        public void validate(Map<String, String> value, ValidationContext context) {
            if (value == null) {
                return;
            }
            ArrayList<String> invalidRanges = new ArrayList<String>();
            for (String range : value.values()) {
                try {
                    VersionRange.withDefaultLexer(range);
                }
                catch (IllegalArgumentException e) {
                    invalidRanges.add(range);
                }
            }
            List<String> invalidApplicationNames = value.keySet().stream().filter(name -> name == null || name.contains("/")).collect(Collectors.toList());
            ArrayList<String> errorParts = new ArrayList<String>();
            if (!invalidRanges.isEmpty()) {
                errorParts.add(String.format(this.messageWrongRange, Strings.mkString(invalidRanges, "', '")));
            }
            if (!invalidApplicationNames.isEmpty()) {
                errorParts.add(String.format(this.messageWrongApplication, Strings.mkString(invalidApplicationNames, "', '")));
            }
            if (!errorParts.isEmpty()) {
                context.error(Strings.mkString(errorParts, ". "), new Object[0]);
            }
        }
    }
}

