/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.msdtyp.SID;
import com.hierynomus.msdtyp.ace.ACE;
import com.hierynomus.msdtyp.ace.AceFlags;
import com.hierynomus.msdtyp.ace.AceHeader;
import com.hierynomus.msdtyp.ace.AceObjectFlags;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.EnumSet;
import java.util.UUID;

class AceType2
extends ACE {
    private EnumSet<AceObjectFlags> flags;
    private UUID objectType;
    private UUID inheritedObjectType;

    AceType2(AceType aceType, EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid) {
        super(new AceHeader(aceType, aceFlags, ACE.HEADER_STRUCTURE_SIZE + 4 + 4 + 16 + 16 + sid.byteCount()), EnumWithValue.EnumUtils.toLong(accessMask), sid);
        this.flags = flags;
        this.objectType = objectType;
        this.inheritedObjectType = inheritedObjectType;
    }

    AceType2() {
    }

    @Override
    protected void writeTo(SMBBuffer buffer) {
        buffer.putUInt32(this.accessMask);
        buffer.putUInt32(EnumWithValue.EnumUtils.toLong(this.flags));
        if (this.flags.contains(AceObjectFlags.ACE_OBJECT_TYPE_PRESENT)) {
            MsDataTypes.putGuid(this.objectType, buffer);
        } else {
            buffer.putReserved(16);
        }
        if (this.flags.contains(AceObjectFlags.ACE_INHERITED_OBJECT_TYPE_PRESENT)) {
            MsDataTypes.putGuid(this.inheritedObjectType, buffer);
        } else {
            buffer.putReserved(16);
        }
        this.getSid().write(buffer);
    }

    @Override
    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        this.accessMask = buffer.readUInt32();
        this.flags = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), AceObjectFlags.class);
        if (this.flags.contains(AceObjectFlags.ACE_OBJECT_TYPE_PRESENT)) {
            this.objectType = MsDataTypes.readGuid(buffer);
        } else {
            buffer.skip(16);
        }
        if (this.flags.contains(AceObjectFlags.ACE_INHERITED_OBJECT_TYPE_PRESENT)) {
            this.inheritedObjectType = MsDataTypes.readGuid(buffer);
        } else {
            buffer.skip(16);
        }
        this.getSid().read(buffer);
    }

    @Override
    public String toString() {
        return "AceType2{flags=" + this.flags + ", objectType=" + this.objectType + ", inheritedObjectType=" + this.inheritedObjectType + "} " + super.toString();
    }
}

