/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.common.SMBBuffer;

public class SMB2IoctlRequest
extends SMB2Packet {
    long MAX_OUTPUT_BUFFER_LENGTH = 65536L;
    private final ControlCode controlCode;
    private final SMB2FileId fileId;
    private final byte[] inputData;
    private final boolean fsctl;

    public SMB2IoctlRequest(SMB2Dialect negotiatedDialect, long sessionId, long treeId, ControlCode controlCode, SMB2FileId fileId, byte[] inputData, boolean fsctl) {
        super(57, negotiatedDialect, SMB2MessageCommandCode.SMB2_IOCTL, sessionId, treeId);
        this.controlCode = controlCode;
        this.fileId = fileId;
        this.inputData = inputData == null ? new byte[]{} : inputData;
        this.fsctl = fsctl;
    }

    @Override
    protected void writeTo(SMBBuffer smbBuffer) {
        smbBuffer.putUInt16(this.structureSize);
        smbBuffer.putReserved2();
        smbBuffer.putUInt32(this.controlCode.getValue());
        this.fileId.write(smbBuffer);
        int offset = 120;
        if (this.inputData.length > 0) {
            smbBuffer.putUInt32(offset);
            smbBuffer.putUInt32(this.inputData.length);
        } else {
            smbBuffer.putUInt32(0L);
            smbBuffer.putUInt32(0L);
        }
        smbBuffer.putUInt32(0L);
        smbBuffer.putUInt32(0L);
        smbBuffer.putUInt32(0L);
        smbBuffer.putUInt32(this.MAX_OUTPUT_BUFFER_LENGTH - (long)(this.inputData.length + 8));
        smbBuffer.putUInt32(this.fsctl ? 1L : 0L);
        smbBuffer.putReserved4();
        if (this.inputData.length > 0) {
            smbBuffer.putRawBytes(this.inputData);
        }
    }

    public static enum ControlCode implements EnumWithValue<ControlCode>
    {
        FSCTL_DFS_GET_REFERRALS(393620L),
        FSCTL_PIPE_PEEK(1130508L),
        FSCTL_PIPE_WAIT(0x110018L),
        FSCTL_PIPE_TRANSCEIVE(1163287L),
        FSCTL_SRV_COPYCHUNK(1327346L),
        FSCTL_SRV_ENUMERATE_SNAPSHOTS(1327204L),
        FSCTL_SRV_REQUEST_RESUME_KEY(1310840L),
        FSCTL_SRV_READ_HASH(0x1441BBL),
        FSCTL_SRV_COPYCHUNK_WRITE(1343730L),
        FSCTL_LMR_REQUEST_RESILIENCY(1311188L),
        FSCTL_QUERY_NETWORK_INTERFACE_INFO(1311228L),
        FSCTL_SET_REPARSE_POINT(589988L),
        FSCTL_DFS_GET_REFERRALS_EX(393648L),
        FSCTL_FILE_LEVEL_TRIM(623112L),
        FSCTL_VALIDATE_NEGOTIATE_INFO(1311236L);

        private long value;

        private ControlCode(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }
}

